/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldWrapper;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;

final class RecordReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_NAME = 1;
    protected static final int STATE_VALUE = 2;
    protected static final int STATE_END = 3;
    protected static final int STATE_DONE = 4;
    private final AvroFieldWrapper[] _fieldReaders;
    private final BinaryDecoder _decoder;
    private final AvroParserImpl _parser;
    private String _currentName;
    protected int _state;
    protected final int _count;

    public RecordReader(AvroFieldWrapper[] fieldReaders) {
        this(null, fieldReaders, null, null);
    }

    private RecordReader(AvroReadContext parent, AvroFieldWrapper[] fieldReaders, BinaryDecoder decoder, AvroParserImpl parser) {
        super(parent, 2);
        this._fieldReaders = fieldReaders;
        this._decoder = decoder;
        this._parser = parser;
        this._count = fieldReaders.length;
    }

    @Override
    public RecordReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
        return new RecordReader(parent, this._fieldReaders, decoder, parser);
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        switch (this._state) {
            case 0: {
                this._parser.setAvroContext(this);
                this._state = this._count > 0 ? 1 : 3;
                return JsonToken.START_OBJECT;
            }
            case 1: {
                if (this._index < this._count) {
                    this._currentName = this._fieldReaders[this._index].getName();
                    this._state = 2;
                    return JsonToken.FIELD_NAME;
                }
            }
            case 3: {
                this._state = 4;
                this._parser.setAvroContext(this.getParent());
                return JsonToken.END_OBJECT;
            }
            case 2: {
                break;
            }
            default: {
                this.throwIllegalState(this._state);
            }
        }
        this._state = 1;
        AvroFieldWrapper field = this._fieldReaders[this._index];
        ++this._index;
        return field.readValue(this, this._parser, this._decoder);
    }

    @Override
    public void appendDesc(StringBuilder sb) {
        sb.append('{');
        if (this._currentName != null) {
            sb.append('\"');
            sb.append(this._currentName);
            sb.append('\"');
        } else {
            sb.append('?');
        }
        sb.append('}');
    }
}

