/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.dataformat.avro.deser.ArrayReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldWrapper;
import com.fasterxml.jackson.dataformat.avro.deser.AvroScalarReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.MapReader;
import com.fasterxml.jackson.dataformat.avro.deser.RecordReader;
import com.fasterxml.jackson.dataformat.avro.deser.ScalarReaderWrapper;
import com.fasterxml.jackson.dataformat.avro.deser.UnionReader;
import java.util.List;
import java.util.TreeMap;
import org.apache.avro.Schema;

public class AvroReaderFactory {
    protected static final AvroScalarReader DECODER_BOOLEAN = new AvroScalarReader.BooleanReader();
    protected static final AvroScalarReader DECODER_BYTES = new AvroScalarReader.BytesReader();
    protected static final AvroScalarReader DECODER_DOUBLE = new AvroScalarReader.DoubleReader();
    protected static final AvroScalarReader DECODER_FLOAT = new AvroScalarReader.FloatReader();
    protected static final AvroScalarReader DECODER_INT = new AvroScalarReader.IntReader();
    protected static final AvroScalarReader DECODER_LONG = new AvroScalarReader.LongReader();
    protected static final AvroScalarReader DECODER_NULL = new AvroScalarReader.NullReader();
    protected static final AvroScalarReader DECODER_STRING = new AvroScalarReader.StringReader();
    protected final TreeMap<String, AvroStructureReader> _knownReaders = new TreeMap();

    public AvroStructureReader createReader(Schema schema) {
        AvroStructureReader reader = this._knownReaders.get(this._typeName(schema));
        if (reader != null) {
            return reader;
        }
        switch (schema.getType()) {
            case ARRAY: {
                return this.createArrayReader(schema);
            }
            case MAP: {
                return this.createMapReader(schema);
            }
            case RECORD: {
                return this.createRecordReader(schema);
            }
            case UNION: {
                return this.createUnionReader(schema);
            }
        }
        return new ScalarReaderWrapper(this.createDecoder(schema));
    }

    public AvroScalarReader createDecoder(Schema type) {
        switch (type.getType()) {
            case BOOLEAN: {
                return DECODER_BOOLEAN;
            }
            case BYTES: {
                return DECODER_BYTES;
            }
            case DOUBLE: {
                return DECODER_DOUBLE;
            }
            case ENUM: {
                return new AvroScalarReader.EnumDecoder(type);
            }
            case FIXED: {
                return new AvroScalarReader.FixedDecoder(type);
            }
            case FLOAT: {
                return DECODER_FLOAT;
            }
            case INT: {
                return DECODER_INT;
            }
            case LONG: {
                return DECODER_LONG;
            }
            case NULL: {
                return DECODER_NULL;
            }
            case STRING: {
                return DECODER_STRING;
            }
            case UNION: {
                List types = type.getTypes();
                AvroScalarReader[] readers = new AvroScalarReader[types.size()];
                int i = 0;
                for (Schema schema : types) {
                    AvroScalarReader reader = this.createDecoder(schema);
                    if (reader == null) {
                        return null;
                    }
                    readers[i++] = reader;
                }
                return new AvroScalarReader.ScalarUnionReader(readers);
            }
            case ARRAY: 
            case MAP: 
            case RECORD: {
                return null;
            }
        }
        throw new IllegalStateException("Unrecognized Avro Schema type: " + type.getType());
    }

    private AvroStructureReader createArrayReader(Schema schema) {
        Schema elementType = schema.getElementType();
        AvroScalarReader scalar = this.createDecoder(elementType);
        if (scalar != null) {
            return ArrayReader.scalar(scalar);
        }
        return ArrayReader.nonScalar(this.createReader(elementType));
    }

    private AvroStructureReader createMapReader(Schema schema) {
        Schema elementType = schema.getValueType();
        AvroScalarReader dec = this.createDecoder(elementType);
        if (dec != null) {
            return new MapReader(dec);
        }
        return new MapReader(this.createReader(elementType));
    }

    private AvroStructureReader createRecordReader(Schema schema) {
        List fields = schema.getFields();
        AvroFieldWrapper[] fieldReaders = new AvroFieldWrapper[fields.size()];
        RecordReader reader = new RecordReader(fieldReaders);
        this._knownReaders.put(this._typeName(schema), reader);
        int i = 0;
        for (Schema.Field field : fields) {
            fieldReaders[i++] = this.createFieldReader(field);
        }
        return reader;
    }

    private AvroStructureReader createUnionReader(Schema schema) {
        List types = schema.getTypes();
        AvroStructureReader[] typeReaders = new AvroStructureReader[types.size()];
        int i = 0;
        for (Schema type : types) {
            typeReaders[i++] = this.createReader(type);
        }
        return new UnionReader(typeReaders);
    }

    private AvroFieldWrapper createFieldReader(Schema.Field field) {
        return this.createFieldReader(field.name(), field.schema());
    }

    private AvroFieldWrapper createFieldReader(String name, Schema type) {
        AvroScalarReader scalar = this.createDecoder(type);
        if (scalar != null) {
            return new AvroFieldWrapper(name, scalar);
        }
        return new AvroFieldWrapper(name, this.createReader(type));
    }

    private String _typeName(Schema schema) {
        return schema.getFullName();
    }
}

