/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.dataformat.avro.AvroFixedSize;
import com.fasterxml.jackson.dataformat.avro.annotation.AvroDecimal;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import com.fasterxml.jackson.dataformat.avro.ser.CustomEncodingSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.reflect.AvroMeta;
import org.apache.avro.reflect.AvroSchema;

public class RecordVisitor
extends JsonObjectFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final VisitorFormatWrapperImpl _visitorWrapper;
    protected final boolean _overridden;
    protected Schema _avroSchema;
    protected List<Schema.Field> _fields = new ArrayList<Schema.Field>();

    public RecordVisitor(SerializerProvider p, JavaType type, VisitorFormatWrapperImpl visitorWrapper) {
        super(p);
        this._type = type;
        this._visitorWrapper = visitorWrapper;
        BeanDescription bean = this.getProvider().getConfig().introspectDirectClassAnnotations(this._type);
        List subTypes = this.getProvider().getAnnotationIntrospector().findSubtypes((Annotated)bean.getClassInfo());
        AvroSchema ann = (AvroSchema)bean.getClassInfo().getAnnotation(AvroSchema.class);
        if (ann != null) {
            this._avroSchema = AvroSchemaHelper.parseJsonSchema(ann.value());
            this._overridden = true;
        } else if (subTypes != null && !subTypes.isEmpty()) {
            ArrayList<Schema> unionSchemas = new ArrayList<Schema>();
            try {
                for (NamedType subType : subTypes) {
                    JsonSerializer ser = this.getProvider().findValueSerializer(subType.getType());
                    VisitorFormatWrapperImpl visitor = this._visitorWrapper.createChildWrapper();
                    ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, this.getProvider().getTypeFactory().constructType((Type)subType.getType()));
                    unionSchemas.add(visitor.getAvroSchema());
                }
                this._avroSchema = Schema.createUnion(unionSchemas);
                this._overridden = true;
            }
            catch (JsonMappingException jme) {
                throw new RuntimeException("Failed to build schema", jme);
            }
        } else {
            this._avroSchema = AvroSchemaHelper.initializeRecordSchema(bean);
            this._overridden = false;
            AvroMeta meta = (AvroMeta)bean.getClassInfo().getAnnotation(AvroMeta.class);
            if (meta != null) {
                this._avroSchema.addProp(meta.key(), meta.value());
            }
        }
        this._visitorWrapper.getSchemas().addSchema(type, this._avroSchema);
    }

    @Override
    public Schema builtAvroSchema() {
        if (!this._overridden) {
            this._avroSchema.setFields(this._fields);
        }
        return this._avroSchema;
    }

    public void property(BeanProperty writer) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        this._fields.add(this.schemaFieldForWriter(writer, false));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType type) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, type);
        Schema schema = visitorWrapper.getAvroSchema();
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    public void optionalProperty(BeanProperty writer) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        this._fields.add(this.schemaFieldForWriter(writer, true));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType type) throws JsonMappingException {
        if (this._overridden) {
            return;
        }
        VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, type);
        Schema schema = visitorWrapper.getAvroSchema();
        if (!type.isPrimitive()) {
            schema = AvroSchemaHelper.unionWithNull(schema);
        }
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    protected Schema.Field schemaFieldForWriter(BeanProperty prop, boolean optional) throws JsonMappingException {
        List aliases;
        Schema writerSchema = null;
        AvroSchema schemaOverride = (AvroSchema)prop.getAnnotation(AvroSchema.class);
        if (schemaOverride != null) {
            Schema.Parser parser = new Schema.Parser();
            writerSchema = parser.parse(schemaOverride.value());
        } else {
            AvroDecimal avroDecimal;
            AvroFixedSize fixedSize = (AvroFixedSize)prop.getAnnotation(AvroFixedSize.class);
            if (fixedSize != null) {
                writerSchema = Schema.createFixed((String)fixedSize.typeName(), null, (String)fixedSize.typeNamespace(), (int)fixedSize.size());
            }
            if (this._visitorWrapper.isLogicalTypesEnabled() && (avroDecimal = (AvroDecimal)prop.getAnnotation(AvroDecimal.class)) != null) {
                if (writerSchema == null) {
                    writerSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
                }
                writerSchema = LogicalTypes.decimal((int)avroDecimal.precision(), (int)avroDecimal.scale()).addToSchema(writerSchema);
            }
            if (writerSchema == null) {
                JsonSerializer ser = null;
                if (prop instanceof BeanPropertyWriter) {
                    BeanPropertyWriter bpw = (BeanPropertyWriter)prop;
                    ser = bpw.getSerializer();
                    optional = optional && !(ser instanceof CustomEncodingSerializer);
                }
                SerializerProvider prov = this.getProvider();
                if (ser == null) {
                    if (prov == null) {
                        throw JsonMappingException.from((SerializerProvider)prov, (String)"SerializerProvider missing for RecordVisitor");
                    }
                    ser = prov.findValueSerializer(prop.getType(), prop);
                }
                VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
                ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, prop.getType());
                writerSchema = visitorWrapper.getAvroSchema();
            }
            if (optional && !prop.getType().isPrimitive()) {
                writerSchema = AvroSchemaHelper.unionWithNull(writerSchema);
            }
        }
        JsonNode defaultValue = AvroSchemaHelper.parseDefaultValue(prop.getMetadata().getDefaultValue());
        writerSchema = this.reorderUnionToMatchDefaultType(writerSchema, defaultValue);
        Schema.Field field = new Schema.Field(prop.getName(), writerSchema, prop.getMetadata().getDescription(), AvroSchemaHelper.jsonNodeToObject(defaultValue));
        AvroMeta meta = (AvroMeta)prop.getAnnotation(AvroMeta.class);
        if (meta != null) {
            field.addProp(meta.key(), meta.value());
        }
        if (!(aliases = prop.findAliases((MapperConfig)this.getProvider().getConfig())).isEmpty()) {
            for (PropertyName pn : aliases) {
                field.addAlias(pn.getSimpleName());
            }
        }
        return field;
    }

    protected Schema reorderUnionToMatchDefaultType(Schema schema, JsonNode defaultValue) {
        int i;
        if (schema == null || defaultValue == null || schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        ArrayList types = new ArrayList(schema.getTypes());
        Integer matchingIndex = null;
        if (defaultValue.isArray()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.ARRAY.getName());
        } else if (defaultValue.isObject()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.MAP.getName());
            if (matchingIndex == null) {
                for (i = 0; i < types.size(); ++i) {
                    if (((Schema)types.get(i)).getType() != Schema.Type.RECORD) continue;
                    matchingIndex = i;
                    break;
                }
            }
        } else if (defaultValue.isBoolean()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.BOOLEAN.getName());
        } else if (defaultValue.isNull()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.NULL.getName());
        } else if (defaultValue.isBinary()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.BYTES.getName());
        } else if (defaultValue.isFloatingPointNumber()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.DOUBLE.getName());
            if (matchingIndex == null) {
                matchingIndex = schema.getIndexNamed(Schema.Type.FLOAT.getName());
            }
        } else if (defaultValue.isIntegralNumber()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.LONG.getName());
            if (matchingIndex == null) {
                matchingIndex = schema.getIndexNamed(Schema.Type.INT.getName());
            }
        } else if (defaultValue.isTextual() && (matchingIndex = schema.getIndexNamed(Schema.Type.STRING.getName())) == null) {
            for (i = 0; i < types.size(); ++i) {
                if (((Schema)types.get(i)).getType() != Schema.Type.ENUM) continue;
                matchingIndex = i;
                break;
            }
        }
        if (matchingIndex != null) {
            types.add(0, types.remove(matchingIndex));
            Map jsonProps = schema.getObjectProps();
            schema = Schema.createUnion(types);
            for (String property : jsonProps.keySet()) {
                schema.addProp(property, jsonProps.get(property));
            }
        }
        return schema;
    }
}

