/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.apacheimpl;

import com.fasterxml.jackson.core.util.RecyclerPool;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;

public final class ApacheCodecRecycler
implements RecyclerPool.WithPool<ApacheCodecRecycler> {
    private final AtomicReference<BinaryDecoder> decoderRef = new AtomicReference();
    private final AtomicReference<BinaryEncoder> encoderRef = new AtomicReference();
    private RecyclerPool<ApacheCodecRecycler> _pool;

    ApacheCodecRecycler() {
    }

    public BinaryDecoder acquireDecoder() {
        return this.decoderRef.getAndSet(null);
    }

    public BinaryEncoder acquireEncoder() {
        return this.encoderRef.getAndSet(null);
    }

    public void release(BinaryDecoder dec) {
        this.decoderRef.set(dec);
    }

    public void release(BinaryEncoder enc) {
        this.encoderRef.set(enc);
    }

    public ApacheCodecRecycler withPool(RecyclerPool<ApacheCodecRecycler> pool) {
        if (this._pool != null) {
            throw new IllegalStateException("ApacheCodecRecycler already linked to pool: " + pool);
        }
        this._pool = Objects.requireNonNull(pool);
        return this;
    }

    public void releaseToPool() {
        if (this._pool != null) {
            RecyclerPool<ApacheCodecRecycler> tmpPool = this._pool;
            this._pool = null;
            tmpPool.releasePooled((RecyclerPool.WithPool)this);
        }
    }
}

