/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.apacheimpl.ApacheCodecRecycler;
import com.fasterxml.jackson.dataformat.avro.ser.AvroWriteContext;
import com.fasterxml.jackson.dataformat.avro.ser.EncodedDatum;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.avro.io.BinaryEncoder;

public class AvroGenerator
extends GeneratorBase {
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected AvroSchema _rootSchema;
    protected final OutputStream _output;
    protected AvroWriteContext _rootContext;
    protected AvroWriteContext _avroContext;
    protected BinaryEncoder _encoder;
    protected boolean _complete;

    public AvroGenerator(IOContext ctxt, int jsonFeatures, int avroFeatures, ObjectCodec codec, OutputStream output) throws IOException {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = avroFeatures;
        this._output = output;
        this._avroContext = AvroWriteContext.nullContext();
        this._encoder = ApacheCodecRecycler.encoder(this._output, this.isEnabled(Feature.AVRO_BUFFERING));
    }

    public void setSchema(AvroSchema schema) {
        if (this._rootSchema == schema) {
            return;
        }
        this._rootSchema = schema;
        this._avroContext = this._rootContext = AvroWriteContext.createRootContext(this, schema.getAvroSchema(), this._encoder);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public AvroGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public AvroGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._output;
    }

    public int getOutputBuffered() {
        return -1;
    }

    public AvroSchema getSchema() {
        return this._rootSchema;
    }

    public void setSchema(FormatSchema schema) {
        if (!(schema instanceof AvroSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + schema.getClass().getName());
        }
        this.setSchema((AvroSchema)schema);
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof AvroSchema;
    }

    public AvroGenerator enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public AvroGenerator disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public AvroGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        int oldF = this._formatFeatures;
        int newF = this._formatFeatures & ~mask | values & mask;
        if (oldF != newF) {
            this._formatFeatures = newF;
        }
        return this;
    }

    public final void writeFieldName(String name) throws IOException {
        this._avroContext.writeFieldName(name);
    }

    public final void writeFieldName(SerializableString name) throws IOException {
        this._avroContext.writeFieldName(name.getValue());
    }

    public final void writeStringField(String fieldName, String value) throws IOException {
        this._avroContext.writeFieldName(fieldName);
        this.writeString(value);
    }

    public final void flush() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._output.flush();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            AvroWriteContext ctxt;
            while ((ctxt = this._avroContext) != null) {
                if (ctxt.inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        if (!this._complete) {
            try {
                this._complete();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonGenerationException("Failed to close AvroGenerator: (" + e.getClass().getName() + "): " + e.getMessage(), (Throwable)e, (JsonGenerator)this);
            }
        }
        if (this._output != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._output.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._output.flush();
            }
        }
        this._releaseBuffers();
    }

    public final void writeStartArray() throws IOException {
        this._avroContext = this._avroContext.createChildArrayContext(null);
        this._complete = false;
    }

    public final void writeEndArray() throws IOException {
        if (!this._avroContext.inArray()) {
            this._reportError("Current context not Array but " + this._avroContext.typeDesc());
        }
        this._avroContext = this._avroContext.getParent();
        if (this._avroContext.inRoot() && !this._complete) {
            this._complete();
        }
    }

    public final void writeStartObject() throws IOException {
        this._avroContext = this._avroContext.createChildObjectContext(null);
        this._complete = false;
    }

    public void writeStartObject(Object forValue) throws IOException {
        this._avroContext = this._avroContext.createChildObjectContext(forValue);
        this._complete = false;
    }

    public final void writeEndObject() throws IOException {
        if (!this._avroContext.inObject()) {
            this._reportError("Current context not Object but " + this._avroContext.typeDesc());
        }
        if (!this._avroContext.canClose()) {
            this._reportError("Can not write END_OBJECT after writing FIELD_NAME but not value");
        }
        this._avroContext = this._avroContext.getParent();
        if (this._avroContext.inRoot() && !this._complete) {
            this._complete();
        }
    }

    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._avroContext.writeString(text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    public final void writeString(SerializableString sstr) throws IOException {
        this.writeString(sstr.toString());
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    public void writeEmbeddedObject(Object object) throws IOException {
        if (object instanceof EncodedDatum) {
            this._avroContext.writeValue(object);
            return;
        }
        super.writeEmbeddedObject(object);
    }

    public void writeRaw(String text) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._avroContext.writeValue(ByteBuffer.wrap(data, offset, len));
    }

    public void writeBoolean(boolean state) throws IOException {
        this._avroContext.writeValue(state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void writeNull() throws IOException {
        this._avroContext.writeNull();
    }

    public void writeNumber(int i) throws IOException {
        this._avroContext.writeValue(i);
    }

    public void writeNumber(long l) throws IOException {
        this._avroContext.writeValue(l);
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._avroContext.writeValue(v);
    }

    public void writeNumber(double d) throws IOException {
        this._avroContext.writeValue(d);
    }

    public void writeNumber(float f) throws IOException {
        this._avroContext.writeValue(Float.valueOf(f));
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._avroContext.writeValue(dec);
    }

    public void writeNumber(String encodedValue) throws IOException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        throw new UnsupportedOperationException("Can not write 'untyped' numbers");
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        this._throwInternal();
    }

    protected void _releaseBuffers() {
        BinaryEncoder e = this._encoder;
        if (e != null) {
            this._encoder = null;
            ApacheCodecRecycler.release(e);
        }
    }

    protected void _complete() throws IOException {
        this._complete = true;
        if (this._rootContext != null) {
            this._rootContext.complete();
        }
    }

    public static enum Feature implements FormatFeature
    {
        AVRO_BUFFERING(true),
        AVRO_FILE_OUTPUT(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }
    }
}

