/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

@JacksonStdImpl
public class StdValueInstantiator
extends ValueInstantiator
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String _valueTypeDesc;
    protected AnnotatedWithParams _defaultCreator;
    protected AnnotatedWithParams _withArgsCreator;
    protected SettableBeanProperty[] _constructorArguments;
    protected JavaType _delegateType;
    protected AnnotatedWithParams _delegateCreator;
    protected SettableBeanProperty[] _delegateArguments;
    protected AnnotatedWithParams _fromStringCreator;
    protected AnnotatedWithParams _fromIntCreator;
    protected AnnotatedWithParams _fromLongCreator;
    protected AnnotatedWithParams _fromDoubleCreator;
    protected AnnotatedWithParams _fromBooleanCreator;
    protected AnnotatedParameter _incompleteParameter;

    public StdValueInstantiator(DeserializationConfig config, Class<?> valueType) {
        this._valueTypeDesc = valueType == null ? "UNKNOWN TYPE" : valueType.getName();
    }

    public StdValueInstantiator(DeserializationConfig config, JavaType valueType) {
        this._valueTypeDesc = valueType == null ? "UNKNOWN TYPE" : valueType.toString();
    }

    protected StdValueInstantiator(StdValueInstantiator src) {
        this._valueTypeDesc = src._valueTypeDesc;
        this._defaultCreator = src._defaultCreator;
        this._constructorArguments = src._constructorArguments;
        this._withArgsCreator = src._withArgsCreator;
        this._delegateType = src._delegateType;
        this._delegateCreator = src._delegateCreator;
        this._delegateArguments = src._delegateArguments;
        this._fromStringCreator = src._fromStringCreator;
        this._fromIntCreator = src._fromIntCreator;
        this._fromLongCreator = src._fromLongCreator;
        this._fromDoubleCreator = src._fromDoubleCreator;
        this._fromBooleanCreator = src._fromBooleanCreator;
    }

    public void configureFromObjectSettings(AnnotatedWithParams defaultCreator, AnnotatedWithParams delegateCreator, JavaType delegateType, SettableBeanProperty[] delegateArgs, AnnotatedWithParams withArgsCreator, SettableBeanProperty[] constructorArgs) {
        this._defaultCreator = defaultCreator;
        this._delegateCreator = delegateCreator;
        this._delegateType = delegateType;
        this._delegateArguments = delegateArgs;
        this._withArgsCreator = withArgsCreator;
        this._constructorArguments = constructorArgs;
    }

    public void configureFromStringCreator(AnnotatedWithParams creator) {
        this._fromStringCreator = creator;
    }

    public void configureFromIntCreator(AnnotatedWithParams creator) {
        this._fromIntCreator = creator;
    }

    public void configureFromLongCreator(AnnotatedWithParams creator) {
        this._fromLongCreator = creator;
    }

    public void configureFromDoubleCreator(AnnotatedWithParams creator) {
        this._fromDoubleCreator = creator;
    }

    public void configureFromBooleanCreator(AnnotatedWithParams creator) {
        this._fromBooleanCreator = creator;
    }

    public void configureIncompleteParameter(AnnotatedParameter parameter) {
        this._incompleteParameter = parameter;
    }

    @Override
    public String getValueTypeDesc() {
        return this._valueTypeDesc;
    }

    @Override
    public boolean canCreateFromString() {
        return this._fromStringCreator != null;
    }

    @Override
    public boolean canCreateFromInt() {
        return this._fromIntCreator != null;
    }

    @Override
    public boolean canCreateFromLong() {
        return this._fromLongCreator != null;
    }

    @Override
    public boolean canCreateFromDouble() {
        return this._fromDoubleCreator != null;
    }

    @Override
    public boolean canCreateFromBoolean() {
        return this._fromBooleanCreator != null;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return this._defaultCreator != null;
    }

    @Override
    public boolean canCreateUsingDelegate() {
        return this._delegateType != null;
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return this._withArgsCreator != null;
    }

    @Override
    public JavaType getDelegateType(DeserializationConfig config) {
        return this._delegateType;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        return this._constructorArguments;
    }

    @Override
    public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
        if (this._defaultCreator == null) {
            throw new IllegalStateException("No default constructor for " + this.getValueTypeDesc());
        }
        try {
            return this._defaultCreator.call();
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
        if (this._withArgsCreator == null) {
            throw new IllegalStateException("No with-args constructor for " + this.getValueTypeDesc());
        }
        try {
            return this._withArgsCreator.call(args);
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
        if (this._delegateCreator == null) {
            throw new IllegalStateException("No delegate constructor for " + this.getValueTypeDesc());
        }
        try {
            if (this._delegateArguments == null) {
                return this._delegateCreator.call1(delegate);
            }
            int len = this._delegateArguments.length;
            Object[] args = new Object[len];
            for (int i = 0; i < len; ++i) {
                SettableBeanProperty prop = this._delegateArguments[i];
                args[i] = prop == null ? delegate : ctxt.findInjectableValue(prop.getInjectableValueId(), prop, null);
            }
            return this._delegateCreator.call(args);
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public Object createFromString(DeserializationContext ctxt, String value) throws IOException {
        if (this._fromStringCreator == null) {
            return this._createFromStringFallbacks(ctxt, value);
        }
        try {
            return this._fromStringCreator.call1(value);
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public Object createFromInt(DeserializationContext ctxt, int value) throws IOException {
        try {
            if (this._fromIntCreator != null) {
                return this._fromIntCreator.call1(value);
            }
            if (this._fromLongCreator != null) {
                return this._fromLongCreator.call1(value);
            }
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
        throw ctxt.mappingException("Can not instantiate value of type %s from Integral number (%s); no single-int-arg constructor/factory method", this.getValueTypeDesc(), value);
    }

    @Override
    public Object createFromLong(DeserializationContext ctxt, long value) throws IOException {
        if (this._fromLongCreator == null) {
            throw ctxt.mappingException("Can not instantiate value of type %s from Long integral number (%s); no single-long-arg constructor/factory method", this.getValueTypeDesc(), value);
        }
        try {
            return this._fromLongCreator.call1(value);
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public Object createFromDouble(DeserializationContext ctxt, double value) throws IOException {
        if (this._fromDoubleCreator == null) {
            throw ctxt.mappingException("Can not instantiate value of type %s from Floating-point number (%s); no one-double/Double-arg constructor/factory method", this.getValueTypeDesc(), value);
        }
        try {
            return this._fromDoubleCreator.call1(value);
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public Object createFromBoolean(DeserializationContext ctxt, boolean value) throws IOException {
        if (this._fromBooleanCreator == null) {
            throw ctxt.mappingException("Can not instantiate value of type %s from Boolean value (%s); no single-boolean/Boolean-arg constructor/factory method", this.getValueTypeDesc(), value);
        }
        try {
            return this._fromBooleanCreator.call1(value);
        }
        catch (Throwable t) {
            throw this.rewrapCtorProblem(ctxt, t);
        }
    }

    @Override
    public AnnotatedWithParams getDelegateCreator() {
        return this._delegateCreator;
    }

    @Override
    public AnnotatedWithParams getDefaultCreator() {
        return this._defaultCreator;
    }

    @Override
    public AnnotatedWithParams getWithArgsCreator() {
        return this._withArgsCreator;
    }

    @Override
    public AnnotatedParameter getIncompleteParameter() {
        return this._incompleteParameter;
    }

    @Deprecated
    protected JsonMappingException wrapException(Throwable t) {
        for (Throwable curr = t; curr != null; curr = curr.getCause()) {
            if (!(curr instanceof JsonMappingException)) continue;
            return (JsonMappingException)((Object)curr);
        }
        return new JsonMappingException(null, "Instantiation of " + this.getValueTypeDesc() + " value failed: " + t.getMessage(), t);
    }

    protected JsonMappingException unwrapAndWrapException(DeserializationContext ctxt, Throwable t) {
        for (Throwable curr = t; curr != null; curr = curr.getCause()) {
            if (!(curr instanceof JsonMappingException)) continue;
            return (JsonMappingException)((Object)curr);
        }
        String msg = String.format("Instantiation of %s value failed (%s): %s", this.getValueTypeDesc(), t.getClass().getName(), t.getMessage());
        return JsonMappingException.from(ctxt.getParser(), msg, t);
    }

    protected JsonMappingException wrapAsJsonMappingException(DeserializationContext ctxt, Throwable t) {
        if (t instanceof JsonMappingException) {
            return (JsonMappingException)((Object)t);
        }
        String msg = String.format("Instantiation of %s value failed (%s): %s", this.getValueTypeDesc(), t.getClass().getName(), t.getMessage());
        return JsonMappingException.from(ctxt.getParser(), msg, t);
    }

    protected JsonMappingException rewrapCtorProblem(DeserializationContext ctxt, Throwable t) {
        Throwable cause;
        if ((t instanceof ExceptionInInitializerError || t instanceof InvocationTargetException) && (cause = t.getCause()) != null) {
            t = cause;
        }
        return this.wrapAsJsonMappingException(ctxt, t);
    }
}

