/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    public BaseNodeDeserializer(Class<T> vc) {
        super(vc);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    protected void _reportProblem(JsonParser p, String msg) throws JsonMappingException {
        throw new JsonMappingException(msg, p.getTokenLocation());
    }

    protected void _handleDuplicateField(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory, String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
        if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            this._reportProblem(p, "Duplicate field '" + fieldName + "' for ObjectNode: not allowed when FAIL_ON_READING_DUP_TREE_KEY enabled");
        }
    }

    protected final ObjectNode deserializeObject(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        String key;
        ObjectNode node = nodeFactory.objectNode();
        if (p.isExpectedStartObjectToken()) {
            key = p.nextFieldName();
        } else {
            JsonToken t = p.getCurrentToken();
            if (t == JsonToken.END_OBJECT) {
                return node;
            }
            if (t != JsonToken.FIELD_NAME) {
                throw ctxt.mappingException(this.handledType(), p.getCurrentToken());
            }
            key = p.getCurrentName();
        }
        while (key != null) {
            JsonNode value;
            JsonToken t = p.nextToken();
            switch (t.id()) {
                case 1: {
                    value = this.deserializeObject(p, ctxt, nodeFactory);
                    break;
                }
                case 3: {
                    value = this.deserializeArray(p, ctxt, nodeFactory);
                    break;
                }
                case 6: {
                    value = nodeFactory.textNode(p.getText());
                    break;
                }
                case 7: {
                    value = this._fromInt(p, ctxt, nodeFactory);
                    break;
                }
                case 9: {
                    value = nodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    value = nodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    value = nodeFactory.nullNode();
                    break;
                }
                default: {
                    value = this.deserializeAny(p, ctxt, nodeFactory);
                }
            }
            JsonNode old = node.replace(key, value);
            if (old != null) {
                this._handleDuplicateField(p, ctxt, nodeFactory, key, node, old, value);
            }
            key = p.nextFieldName();
        }
        return node;
    }

    protected final ArrayNode deserializeArray(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        ArrayNode node = nodeFactory.arrayNode();
        block10: while (true) {
            JsonToken t;
            if ((t = p.nextToken()) == null) {
                throw ctxt.mappingException("Unexpected end-of-input when binding data into ArrayNode");
            }
            switch (t.id()) {
                case 1: {
                    node.add(this.deserializeObject(p, ctxt, nodeFactory));
                    continue block10;
                }
                case 3: {
                    node.add(this.deserializeArray(p, ctxt, nodeFactory));
                    continue block10;
                }
                case 4: {
                    return node;
                }
                case 6: {
                    node.add(nodeFactory.textNode(p.getText()));
                    continue block10;
                }
                case 7: {
                    node.add(this._fromInt(p, ctxt, nodeFactory));
                    continue block10;
                }
                case 9: {
                    node.add(nodeFactory.booleanNode(true));
                    continue block10;
                }
                case 10: {
                    node.add(nodeFactory.booleanNode(false));
                    continue block10;
                }
                case 11: {
                    node.add(nodeFactory.nullNode());
                    continue block10;
                }
            }
            node.add(this.deserializeAny(p, ctxt, nodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 1: 
            case 2: {
                return this.deserializeObject(p, ctxt, nodeFactory);
            }
            case 3: {
                return this.deserializeArray(p, ctxt, nodeFactory);
            }
            case 5: {
                return this.deserializeObject(p, ctxt, nodeFactory);
            }
            case 12: {
                return this._fromEmbedded(p, ctxt, nodeFactory);
            }
            case 6: {
                return nodeFactory.textNode(p.getText());
            }
            case 7: {
                return this._fromInt(p, ctxt, nodeFactory);
            }
            case 8: {
                return this._fromFloat(p, ctxt, nodeFactory);
            }
            case 9: {
                return nodeFactory.booleanNode(true);
            }
            case 10: {
                return nodeFactory.booleanNode(false);
            }
            case 11: {
                return nodeFactory.nullNode();
            }
        }
        throw ctxt.mappingException(this.handledType());
    }

    protected final JsonNode _fromInt(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonParser.NumberType nt = p.getNumberType();
        if (nt == JsonParser.NumberType.BIG_INTEGER || ctxt.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
            return nodeFactory.numberNode(p.getBigIntegerValue());
        }
        if (nt == JsonParser.NumberType.INT) {
            return nodeFactory.numberNode(p.getIntValue());
        }
        return nodeFactory.numberNode(p.getLongValue());
    }

    protected final JsonNode _fromFloat(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonParser.NumberType nt = p.getNumberType();
        if (nt == JsonParser.NumberType.BIG_DECIMAL || ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            return nodeFactory.numberNode(p.getDecimalValue());
        }
        return nodeFactory.numberNode(p.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        Object ob = p.getEmbeddedObject();
        if (ob == null) {
            return nodeFactory.nullNode();
        }
        Class<?> type = ob.getClass();
        if (type == byte[].class) {
            return nodeFactory.binaryNode((byte[])ob);
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (JsonNode)ob;
        }
        return nodeFactory.pojoNode(ob);
    }
}

