/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.SetterlessProperty;
import com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.fasterxml.jackson.databind.deser.std.ThrowableDeserializer;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class BeanDeserializerFactory
extends BasicDeserializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    private static final Class<?>[] NO_VIEWS = new Class[0];
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(new DeserializerFactoryConfig());

    public BeanDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        super(deserializerFactoryConfig);
    }

    @Override
    public DeserializerFactory withConfig(DeserializerFactoryConfig deserializerFactoryConfig) {
        if (this._factoryConfig == deserializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanDeserializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanDeserializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalDeserializers': can not instantiate subtype with " + "additional deserializer definitions");
        }
        return new BeanDeserializerFactory(deserializerFactoryConfig);
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> jsonDeserializer = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JsonDeserializer<Object> jsonDeserializer2 = this._findCustomBeanDeserializer(javaType, deserializationConfig, beanDescription);
        if (jsonDeserializer2 != null) {
            return jsonDeserializer2;
        }
        if (javaType.isThrowable()) {
            return this.buildThrowableDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (javaType.isAbstract() && (jsonDeserializer = this.materializeAbstractType(deserializationContext, javaType, beanDescription)) != null) {
            beanDescription = deserializationConfig.introspect((JavaType)((Object)jsonDeserializer));
            return this.buildBeanDeserializer(deserializationContext, (JavaType)((Object)jsonDeserializer), beanDescription);
        }
        jsonDeserializer = this.findStdDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        if (!this.isPotentialBeanType(javaType.getRawClass())) {
            return null;
        }
        return this.buildBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    @Override
    public JsonDeserializer<Object> createBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription, Class<?> clazz) throws JsonMappingException {
        JavaType javaType2 = deserializationContext.constructType(clazz);
        Object t = deserializationContext.getConfig().introspectForBuilder(javaType2);
        return this.buildBuilderBasedDeserializer(deserializationContext, javaType, (BeanDescription)t);
    }

    protected JsonDeserializer<?> findStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer = this.findDefaultDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        Class<?> clazz = javaType.getRawClass();
        if (AtomicReference.class.isAssignableFrom(clazz)) {
            TypeFactory typeFactory = deserializationContext.getTypeFactory();
            JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType, AtomicReference.class);
            JavaType javaType2 = javaTypeArray == null || javaTypeArray.length < 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            return new AtomicReferenceDeserializer(javaType2);
        }
        return this.findOptionalStdDeserializer(deserializationContext, javaType, beanDescription);
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    protected JavaType materializeAbstractType(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JavaType javaType2 = beanDescription.getType();
        for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
            JavaType javaType3 = abstractTypeResolver.resolveAbstractType(deserializationContext.getConfig(), javaType2);
            if (javaType3 == null) continue;
            return javaType3;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addObjectIdReader(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addInjectables(deserializationContext, beanDescription, beanDeserializerBuilder);
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = object.updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        JsonDeserializer jsonDeserializer = javaType.isAbstract() && !valueInstantiator.canInstantiate() ? beanDeserializerBuilder.buildAbstract() : beanDeserializerBuilder.build();
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> buildBuilderBasedDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addObjectIdReader(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addReferenceProperties(deserializationContext, beanDescription, beanDeserializerBuilder);
        this.addInjectables(deserializationContext, beanDescription, beanDeserializerBuilder);
        JsonPOJOBuilder.Value value = beanDescription.findPOJOBuilderConfig();
        String string = value == null ? "build" : value.buildMethodName;
        AnnotatedMethod annotatedMethod = beanDescription.findMethod(string, null);
        if (annotatedMethod != null && deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember());
        }
        beanDeserializerBuilder.setPOJOBuilder(annotatedMethod, value);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object : this._factoryConfig.deserializerModifiers()) {
                beanDeserializerBuilder = object.updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        JsonDeserializer<?> jsonDeserializer = beanDeserializerBuilder.buildBuilderBased(javaType, string);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected void addObjectIdReader(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        ObjectIdGenerator objectIdGenerator;
        JavaType javaType;
        SettableBeanProperty settableBeanProperty;
        Object object;
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            object = objectIdInfo.getPropertyName();
            settableBeanProperty = beanDeserializerBuilder.findProperty((PropertyName)object);
            if (settableBeanProperty == null) {
                throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": can not find property with name '" + object + "'");
            }
            javaType = settableBeanProperty.getType();
            objectIdGenerator = new ObjectIdGenerator(objectIdInfo.getScope());
        } else {
            object = deserializationContext.constructType(clazz);
            javaType = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object, ObjectIdGenerator.class)[0];
            settableBeanProperty = null;
            objectIdGenerator = deserializationContext.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        }
        object = deserializationContext.findRootValueDeserializer(javaType);
        beanDeserializerBuilder.setObjectIdReader(ObjectIdReader.construct(javaType, objectIdInfo.getPropertyName(), objectIdGenerator, object, settableBeanProperty));
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Iterator<BeanDeserializerModifier> iterator;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDeserializerBuilder beanDeserializerBuilder = this.constructBeanDeserializerBuilder(deserializationContext, beanDescription);
        beanDeserializerBuilder.setValueInstantiator(this.findValueInstantiator(deserializationContext, beanDescription));
        this.addBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder);
        AnnotatedMethod annotatedMethod = beanDescription.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (annotatedMethod != null && (iterator = this.constructSettableProperty(deserializationContext, beanDescription, (BeanPropertyDefinition)((Object)(jsonDeserializer = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), annotatedMethod, "cause"))), annotatedMethod.getGenericParameterType(0))) != null) {
            beanDeserializerBuilder.addOrReplaceProperty((SettableBeanProperty)((Object)iterator), true);
        }
        beanDeserializerBuilder.addIgnorable("localizedMessage");
        beanDeserializerBuilder.addIgnorable("suppressed");
        beanDeserializerBuilder.addIgnorable("message");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            jsonDeserializer = this._factoryConfig.deserializerModifiers().iterator();
            while (jsonDeserializer.hasNext()) {
                iterator = jsonDeserializer.next();
                beanDeserializerBuilder = ((BeanDeserializerModifier)((Object)iterator)).updateBuilder(deserializationConfig, beanDescription, beanDeserializerBuilder);
            }
        }
        if ((jsonDeserializer = beanDeserializerBuilder.build()) instanceof BeanDeserializer) {
            jsonDeserializer = new ThrowableDeserializer((BeanDeserializer)jsonDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyDeserializer(deserializationConfig, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        return new BeanDeserializerBuilder(beanDescription, deserializationContext.getConfig());
    }

    protected void addBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list;
        Object object;
        SettableBeanProperty[] settableBeanPropertyArray = beanDeserializerBuilder.getValueInstantiator().getFromObjectArguments(deserializationContext.getConfig());
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        boolean bl = false;
        Serializable serializable = annotationIntrospector.findIgnoreUnknownProperties(beanDescription.getClassInfo());
        if (serializable != null) {
            bl = (Boolean)serializable;
            beanDeserializerBuilder.setIgnoreUnknownProperties(bl);
        }
        serializable = ArrayBuilders.arrayToSet(annotationIntrospector.findPropertiesToIgnore(beanDescription.getClassInfo()));
        Object object2 = serializable.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            beanDeserializerBuilder.addIgnorable((String)object);
        }
        object2 = beanDescription.findAnySetter();
        if (object2 != null) {
            beanDeserializerBuilder.setAnySetter(this.constructAnySetter(deserializationContext, beanDescription, (AnnotatedMethod)object2));
        }
        if (object2 == null && (object = beanDescription.getIgnoredPropertyNames()) != null) {
            list = object.iterator();
            while (list.hasNext()) {
                Iterator<BeanDeserializerModifier> iterator = (String)list.next();
                beanDeserializerBuilder.addIgnorable((String)((Object)iterator));
            }
        }
        boolean bl2 = deserializationContext.isEnabled(MapperFeature.USE_GETTERS_AS_SETTERS) && deserializationContext.isEnabled(MapperFeature.AUTO_DETECT_GETTERS);
        list = this.filterBeanProps(deserializationContext, beanDescription, beanDeserializerBuilder, beanDescription.findProperties(), (Set<String>)((Object)serializable));
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier object3 : this._factoryConfig.deserializerModifiers()) {
                list = object3.updateProperties(deserializationContext.getConfig(), beanDescription, list);
            }
        }
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            Serializable serializable2;
            Class<?>[] classArray;
            Serializable serializable3 = null;
            if (beanPropertyDefinition.hasSetter()) {
                classArray = beanPropertyDefinition.getSetter().getGenericParameterType(0);
                serializable3 = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (Type)classArray);
            } else if (beanPropertyDefinition.hasField()) {
                classArray = beanPropertyDefinition.getField().getGenericType();
                serializable3 = this.constructSettableProperty(deserializationContext, beanDescription, beanPropertyDefinition, (Type)classArray);
            } else if (bl2 && beanPropertyDefinition.hasGetter() && (Collection.class.isAssignableFrom((Class<?>)(serializable2 = (classArray = beanPropertyDefinition.getGetter()).getRawType())) || Map.class.isAssignableFrom((Class<?>)serializable2))) {
                serializable3 = this.constructSetterlessProperty(deserializationContext, beanDescription, beanPropertyDefinition);
            }
            if (beanPropertyDefinition.hasConstructorParameter()) {
                classArray = beanPropertyDefinition.getName();
                serializable2 = null;
                if (settableBeanPropertyArray != null) {
                    for (SettableBeanProperty settableBeanProperty : settableBeanPropertyArray) {
                        if (!classArray.equals(settableBeanProperty.getName())) continue;
                        serializable2 = (CreatorProperty)settableBeanProperty;
                        break;
                    }
                }
                if (serializable2 == null) {
                    throw deserializationContext.mappingException("Could not find creator property with name '" + classArray + "' (in class " + beanDescription.getBeanClass().getName() + ")");
                }
                if (serializable3 != null) {
                    serializable2 = ((CreatorProperty)serializable2).withFallbackSetter((SettableBeanProperty)serializable3);
                }
                serializable3 = serializable2;
                beanDeserializerBuilder.addCreatorProperty((SettableBeanProperty)serializable2);
                continue;
            }
            if (serializable3 == null) continue;
            classArray = beanPropertyDefinition.findViews();
            if (classArray == null && !deserializationContext.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                classArray = NO_VIEWS;
            }
            serializable3.setViews(classArray);
            beanDeserializerBuilder.addProperty((SettableBeanProperty)serializable3);
        }
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder, List<BeanPropertyDefinition> list, Set<String> set) throws JsonMappingException {
        ArrayList<BeanPropertyDefinition> arrayList = new ArrayList<BeanPropertyDefinition>(Math.max(4, list.size()));
        HashMap hashMap = new HashMap();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            String string = beanPropertyDefinition.getName();
            if (set.contains(string)) continue;
            if (!beanPropertyDefinition.hasConstructorParameter()) {
                Class<?> clazz = null;
                if (beanPropertyDefinition.hasSetter()) {
                    clazz = beanPropertyDefinition.getSetter().getRawParameterType(0);
                } else if (beanPropertyDefinition.hasField()) {
                    clazz = beanPropertyDefinition.getField().getRawType();
                }
                if (clazz != null && this.isIgnorableType(deserializationContext.getConfig(), beanDescription, clazz, hashMap)) {
                    beanDeserializerBuilder.addIgnorable(string);
                    continue;
                }
            }
            arrayList.add(beanPropertyDefinition);
        }
        return arrayList;
    }

    protected void addReferenceProperties(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        Map<String, AnnotatedMember> map = beanDescription.findBackReferenceProperties();
        if (map != null) {
            for (Map.Entry<String, AnnotatedMember> entry : map.entrySet()) {
                String string = entry.getKey();
                AnnotatedMember annotatedMember = entry.getValue();
                Type type = annotatedMember instanceof AnnotatedMethod ? ((AnnotatedMethod)annotatedMember).getGenericParameterType(0) : annotatedMember.getRawType();
                SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), annotatedMember);
                beanDeserializerBuilder.addBackReferenceProperty(string, this.constructSettableProperty(deserializationContext, beanDescription, simpleBeanPropertyDefinition, type));
            }
        }
    }

    protected void addInjectables(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) throws JsonMappingException {
        Map<Object, AnnotatedMember> map = beanDescription.findInjectables();
        if (map != null) {
            boolean bl = deserializationContext.canOverrideAccessModifiers();
            for (Map.Entry<Object, AnnotatedMember> entry : map.entrySet()) {
                AnnotatedMember annotatedMember = entry.getValue();
                if (bl) {
                    annotatedMember.fixAccess();
                }
                beanDeserializerBuilder.addInjectable(new PropertyName(annotatedMember.getName()), beanDescription.resolveType(annotatedMember.getGenericType()), beanDescription.getClassAnnotations(), annotatedMember, entry.getKey());
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedMethod annotatedMethod) throws JsonMappingException {
        if (deserializationContext.canOverrideAccessModifiers()) {
            annotatedMethod.fixAccess();
        }
        JavaType javaType = beanDescription.bindingsForBeanType().resolveType(annotatedMethod.getGenericParameterType(1));
        BeanProperty.Std std = new BeanProperty.Std(new PropertyName(annotatedMethod.getName()), javaType, null, beanDescription.getClassAnnotations(), (AnnotatedMember)annotatedMethod, PropertyMetadata.STD_OPTIONAL);
        javaType = this.resolveType(deserializationContext, beanDescription, javaType, annotatedMethod);
        JsonDeserializer<Object> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMethod);
        if (jsonDeserializer != null) {
            return new SettableAnyProperty((BeanProperty)std, annotatedMethod, javaType, jsonDeserializer);
        }
        javaType = this.modifyTypeByAnnotation(deserializationContext, annotatedMethod, javaType);
        return new SettableAnyProperty((BeanProperty)std, annotatedMethod, javaType, null);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, Type type) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty referenceProperty;
        AnnotatedMember annotatedMember = beanPropertyDefinition.getNonConstructorMutator();
        if (deserializationContext.canOverrideAccessModifiers()) {
            annotatedMember.fixAccess();
        }
        JavaType javaType = beanDescription.resolveType(type);
        BeanProperty.Std std = new BeanProperty.Std(beanPropertyDefinition.getFullName(), javaType, beanPropertyDefinition.getWrapperName(), beanDescription.getClassAnnotations(), annotatedMember, beanPropertyDefinition.getMetadata());
        JavaType javaType2 = this.resolveType(deserializationContext, beanDescription, javaType, annotatedMember);
        if (javaType2 != javaType) {
            std = std.withType(javaType2);
        }
        JsonDeserializer<Object> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMember);
        javaType2 = this.modifyTypeByAnnotation(deserializationContext, annotatedMember, javaType2);
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        SettableBeanProperty settableBeanProperty = annotatedMember instanceof AnnotatedMethod ? new MethodProperty(beanPropertyDefinition, javaType2, typeDeserializer, beanDescription.getClassAnnotations(), (AnnotatedMethod)annotatedMember) : new FieldProperty(beanPropertyDefinition, javaType2, typeDeserializer, beanDescription.getClassAnnotations(), (AnnotatedField)annotatedMember);
        if (jsonDeserializer != null) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        }
        if ((referenceProperty = beanPropertyDefinition.findReferenceType()) != null && referenceProperty.isManagedReference()) {
            settableBeanProperty.setManagedReferenceName(referenceProperty.getName());
        }
        return settableBeanProperty;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition) throws JsonMappingException {
        AnnotatedMethod annotatedMethod = beanPropertyDefinition.getGetter();
        if (deserializationContext.canOverrideAccessModifiers()) {
            annotatedMethod.fixAccess();
        }
        JavaType javaType = annotatedMethod.getType(beanDescription.bindingsForBeanType());
        JsonDeserializer<Object> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedMethod);
        javaType = this.modifyTypeByAnnotation(deserializationContext, annotatedMethod, javaType);
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        SettableBeanProperty settableBeanProperty = new SetterlessProperty(beanPropertyDefinition, javaType, typeDeserializer, beanDescription.getClassAnnotations(), annotatedMethod);
        if (jsonDeserializer != null) {
            settableBeanProperty = ((SettableBeanProperty)settableBeanProperty).withValueDeserializer(jsonDeserializer);
        }
        return settableBeanProperty;
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        String string = ClassUtil.canBeABeanType(clazz);
        if (string != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        if (ClassUtil.isProxyType(clazz)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + clazz.getName() + " as a Bean");
        }
        string = ClassUtil.isLocalType(clazz, true);
        if (string != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + clazz.getName() + " (of type " + string + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig deserializationConfig, BeanDescription beanDescription, Class<?> clazz, Map<Class<?>, Boolean> map) {
        Boolean bl = map.get(clazz);
        if (bl == null) {
            BeanDescription beanDescription2 = deserializationConfig.introspectClassAnnotations(clazz);
            bl = deserializationConfig.getAnnotationIntrospector().isIgnorableType(beanDescription2.getClassInfo());
            if (bl == null) {
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }
}

