/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public class JacksonDeserializers {
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{new JavaTypeDeserializer(), new TokenBufferDeserializer()};
    }

    public static ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc) {
        if (beanDesc.getBeanClass() == JsonLocation.class) {
            return new JsonLocationInstantiator();
        }
        return null;
    }

    @JacksonStdImpl
    public static class TokenBufferDeserializer
    extends StdScalarDeserializer<TokenBuffer> {
        public TokenBufferDeserializer() {
            super(TokenBuffer.class);
        }

        @Override
        public TokenBuffer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TokenBuffer tb = new TokenBuffer(jp.getCodec());
            tb.copyCurrentStructure(jp);
            return tb;
        }
    }

    public static class JsonLocationInstantiator
    extends ValueInstantiator {
        @Override
        public String getValueTypeDesc() {
            return JsonLocation.class.getName();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return true;
        }

        public CreatorProperty[] getFromObjectArguments(DeserializationConfig config) {
            JavaType intType = config.constructType(Integer.TYPE);
            JavaType longType = config.constructType(Long.TYPE);
            return new CreatorProperty[]{new CreatorProperty("sourceRef", config.constructType(Object.class), null, null, null, 0, null), new CreatorProperty("byteOffset", longType, null, null, null, 1, null), new CreatorProperty("charOffset", longType, null, null, null, 2, null), new CreatorProperty("lineNr", intType, null, null, null, 3, null), new CreatorProperty("columnNr", intType, null, null, null, 4, null)};
        }

        @Override
        public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
            return new JsonLocation(args[0], JsonLocationInstantiator._long(args[1]), JsonLocationInstantiator._long(args[2]), JsonLocationInstantiator._int(args[3]), JsonLocationInstantiator._int(args[4]));
        }

        private static final long _long(Object o) {
            return o == null ? 0L : ((Number)o).longValue();
        }

        private static final int _int(Object o) {
            return o == null ? 0 : ((Number)o).intValue();
        }
    }

    public static class JavaTypeDeserializer
    extends StdScalarDeserializer<JavaType> {
        public JavaTypeDeserializer() {
            super(JavaType.class);
        }

        @Override
        public JavaType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken curr = jp.getCurrentToken();
            if (curr == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return (JavaType)((Object)this.getEmptyValue());
                }
                return ctxt.getTypeFactory().constructFromCanonical(str);
            }
            if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return (JavaType)((Object)jp.getEmbeddedObject());
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }
}

