/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.stax;

import com.fasterxml.aalto.AsyncXMLInputFactory;
import com.fasterxml.aalto.AsyncXMLStreamReader;
import com.fasterxml.aalto.async.AsyncStreamReaderImpl;
import com.fasterxml.aalto.async.AsyncUtfScanner;
import com.fasterxml.aalto.dom.DOMReaderImpl;
import com.fasterxml.aalto.evt.EventAllocatorImpl;
import com.fasterxml.aalto.evt.EventReaderImpl;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.ByteSourceBootstrapper;
import com.fasterxml.aalto.in.CharSourceBootstrapper;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.stax.StreamReaderImpl;
import com.fasterxml.aalto.util.IllegalCharHandler;
import com.fasterxml.aalto.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.io.Stax2CharArraySource;
import org.codehaus.stax2.io.Stax2Source;
import org.codehaus.stax2.ri.Stax2FilteredStreamReader;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;
import org.codehaus.stax2.ri.evt.Stax2EventReaderAdapter;
import org.codehaus.stax2.ri.evt.Stax2FilteredEventReader;
import org.xml.sax.InputSource;

public final class InputFactoryImpl
extends AsyncXMLInputFactory {
    final ReaderConfig _config = new ReaderConfig();
    protected XMLEventAllocator _allocator = null;

    public XMLEventReader createFilteredReader(XMLEventReader xMLEventReader, EventFilter eventFilter) {
        return new Stax2FilteredEventReader(Stax2EventReaderAdapter.wrapIfNecessary((XMLEventReader)xMLEventReader), eventFilter);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) throws XMLStreamException {
        Stax2FilteredStreamReader stax2FilteredStreamReader = new Stax2FilteredStreamReader(xMLStreamReader, streamFilter);
        if (!streamFilter.accept((XMLStreamReader)stax2FilteredStreamReader)) {
            stax2FilteredStreamReader.next();
        }
        return stax2FilteredStreamReader;
    }

    public XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException {
        return this.createXMLEventReader(inputStream, null);
    }

    public XMLEventReader createXMLEventReader(InputStream inputStream, String string) throws XMLStreamException {
        return this.constructER(this.constructSR(inputStream, string, true));
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(null, reader);
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.constructER(this.constructSR(source, true));
    }

    public XMLEventReader createXMLEventReader(String string, InputStream inputStream) throws XMLStreamException {
        return this.constructER(this.constructSR(string, inputStream, true));
    }

    public XMLEventReader createXMLEventReader(String string, Reader reader) throws XMLStreamException {
        return this.constructER(this.constructSR(string, reader, true));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return this.constructER(Stax2ReaderAdapter.wrapIfNecessary((XMLStreamReader)xMLStreamReader));
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return this.constructSR(inputStream, null, false);
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream, String string) throws XMLStreamException {
        return this.constructSR(inputStream, string, false);
    }

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.constructSR(null, reader, false);
    }

    public XMLStreamReader createXMLStreamReader(String string, Reader reader) throws XMLStreamException {
        return this.constructSR(string, reader, false);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.constructSR(source, false);
    }

    public XMLStreamReader createXMLStreamReader(String string, InputStream inputStream) throws XMLStreamException {
        return this.constructSR(string, inputStream, false);
    }

    public Object getProperty(String string) {
        return this._config.getProperty(string, true);
    }

    public void setProperty(String string, Object object) {
        this._config.setProperty(string, object);
    }

    public XMLEventAllocator getEventAllocator() {
        return this._allocator;
    }

    public XMLReporter getXMLReporter() {
        return this._config.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this._config.getXMLResolver();
    }

    public boolean isPropertySupported(String string) {
        return this._config.isPropertySupported(string);
    }

    public void setEventAllocator(XMLEventAllocator xMLEventAllocator) {
        this._allocator = xMLEventAllocator;
    }

    public void setXMLReporter(XMLReporter xMLReporter) {
        this._config.setXMLReporter(xMLReporter);
    }

    public void setXMLResolver(XMLResolver xMLResolver) {
        this._config.setXMLResolver(xMLResolver);
    }

    public XMLEventReader2 createXMLEventReader(URL uRL) throws XMLStreamException {
        return this.constructER(this.constructSR(uRL, true));
    }

    public XMLEventReader2 createXMLEventReader(File file) throws XMLStreamException {
        return this.constructER(this.constructSR(file, true));
    }

    public XMLStreamReader2 createXMLStreamReader(URL uRL) throws XMLStreamException {
        return this.constructSR(uRL, false);
    }

    public XMLStreamReader2 createXMLStreamReader(File file) throws XMLStreamException {
        return this.constructSR(file, false);
    }

    public void configureForXmlConformance() {
        this._config.configureForXmlConformance();
    }

    public void configureForConvenience() {
        this._config.configureForConvenience();
    }

    public void configureForSpeed() {
        this._config.configureForSpeed();
    }

    public void configureForLowMemUsage() {
        this._config.configureForLowMemUsage();
    }

    public void configureForRoundTripping() {
        this._config.configureForRoundTripping();
    }

    @Override
    public AsyncXMLStreamReader createAsyncXMLStreamReader() {
        ReaderConfig readerConfig = this.getNonSharedConfig(null, null, null, false, false);
        readerConfig.setActualEncoding("UTF-8");
        return new AsyncStreamReaderImpl(new AsyncUtfScanner(readerConfig));
    }

    public AsyncXMLStreamReader createAsyncXMLStreamReader(IllegalCharHandler illegalCharHandler) {
        ReaderConfig readerConfig = this.getNonSharedConfig(null, null, null, false, false);
        readerConfig.setActualEncoding("UTF-8");
        readerConfig.setIllegalCharHandler(illegalCharHandler);
        return new AsyncStreamReaderImpl(new AsyncUtfScanner(readerConfig));
    }

    @Override
    public AsyncXMLStreamReader createAsyncXMLStreamReader(byte[] byArray) {
        return this.createAsyncXMLStreamReader(byArray, 0, byArray.length);
    }

    @Override
    public AsyncXMLStreamReader createAsyncXMLStreamReader(byte[] byArray, int n, int n2) {
        AsyncXMLStreamReader asyncXMLStreamReader = this.createAsyncXMLStreamReader();
        return asyncXMLStreamReader;
    }

    public ReaderConfig getNonSharedConfig(String string, String string2, String string3, boolean bl, boolean bl2) {
        ReaderConfig readerConfig = this._config.createNonShared(string2, string, string3);
        if (bl) {
            readerConfig.doParseLazily(false);
        }
        if (bl2) {
            readerConfig.doAutoCloseInput(true);
        }
        return readerConfig;
    }

    protected XMLStreamReader2 constructSR(InputStream inputStream, String string, boolean bl) throws XMLStreamException {
        ReaderConfig readerConfig = this.getNonSharedConfig(null, null, string, bl, false);
        return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, inputStream));
    }

    protected XMLStreamReader2 constructSR(String string, Reader reader, boolean bl) throws XMLStreamException {
        ReaderConfig readerConfig = this.getNonSharedConfig(null, string, null, bl, false);
        return StreamReaderImpl.construct(CharSourceBootstrapper.construct(readerConfig, reader));
    }

    protected XMLStreamReader2 constructSR(String string, InputStream inputStream, boolean bl) throws XMLStreamException {
        ReaderConfig readerConfig = this.getNonSharedConfig(null, string, null, bl, false);
        return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, inputStream));
    }

    protected XMLStreamReader2 constructSR(Source source, boolean bl) throws XMLStreamException {
        Object object;
        boolean bl2;
        Object object2;
        if (source instanceof Stax2Source) {
            return this.constructSR2((Stax2Source)source, bl);
        }
        Reader reader = null;
        InputStream inputStream = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (source instanceof StreamSource) {
            object2 = (StreamSource)source;
            string2 = ((StreamSource)object2).getSystemId();
            string = ((StreamSource)object2).getPublicId();
            inputStream = ((StreamSource)object2).getInputStream();
            if (inputStream == null) {
                reader = ((StreamSource)object2).getReader();
            }
            bl2 = false;
        } else if (source instanceof SAXSource) {
            object2 = (SAXSource)source;
            string2 = ((SAXSource)object2).getSystemId();
            object = ((SAXSource)object2).getInputSource();
            if (object != null) {
                string2 = ((InputSource)object).getSystemId();
                string = ((InputSource)object).getPublicId();
                string3 = ((InputSource)object).getEncoding();
                inputStream = ((InputSource)object).getByteStream();
                if (inputStream == null) {
                    reader = ((InputSource)object).getCharacterStream();
                }
            }
            bl2 = false;
        } else {
            if (source instanceof DOMSource) {
                boolean bl3 = false;
                ReaderConfig readerConfig = this.getNonSharedConfig(string, string2, string3, bl, bl3);
                return DOMReaderImpl.createFrom((DOMSource)source, readerConfig);
            }
            throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + source.getClass() + " (unrecognized type)");
        }
        if (inputStream != null) {
            object2 = this.getNonSharedConfig(string, string2, string3, bl, bl2);
            return StreamReaderImpl.construct(ByteSourceBootstrapper.construct((ReaderConfig)object2, inputStream));
        }
        if (reader != null) {
            object2 = this.getNonSharedConfig(string, string2, string3, bl, bl2);
            return StreamReaderImpl.construct(CharSourceBootstrapper.construct((ReaderConfig)object2, reader));
        }
        if (string2 != null && string2.length() > 0) {
            bl2 = true;
            object2 = this.getNonSharedConfig(string, string2, string3, bl, bl2);
            try {
                object = URLUtil.urlFromSystemId(string2);
                inputStream = URLUtil.inputStreamFromURL((URL)object);
                return StreamReaderImpl.construct(ByteSourceBootstrapper.construct((ReaderConfig)object2, inputStream));
            }
            catch (IOException iOException) {
                throw new IoStreamException(iOException);
            }
        }
        throw new XMLStreamException("Can not create Stax reader for the Source passed -- neither reader, input stream nor system id was accessible; can not use other types of sources (like embedded SAX streams)");
    }

    protected XMLStreamReader2 constructSR2(Stax2Source stax2Source, boolean bl) throws XMLStreamException {
        ReaderConfig readerConfig = this.getNonSharedConfig(stax2Source.getPublicId(), stax2Source.getSystemId(), stax2Source.getEncoding(), bl, true);
        if (stax2Source instanceof Stax2ByteArraySource) {
            Stax2ByteArraySource stax2ByteArraySource = (Stax2ByteArraySource)stax2Source;
            return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, stax2ByteArraySource.getBuffer(), stax2ByteArraySource.getBufferStart(), stax2ByteArraySource.getBufferLength()));
        }
        if (stax2Source instanceof Stax2CharArraySource) {
            Stax2CharArraySource stax2CharArraySource = (Stax2CharArraySource)stax2Source;
            return StreamReaderImpl.construct(CharSourceBootstrapper.construct(readerConfig, stax2CharArraySource.getBuffer(), stax2CharArraySource.getBufferStart(), stax2CharArraySource.getBufferLength()));
        }
        try {
            InputStream inputStream = stax2Source.constructInputStream();
            if (inputStream != null) {
                return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, inputStream));
            }
            Reader reader = stax2Source.constructReader();
            if (reader != null) {
                return StreamReaderImpl.construct(CharSourceBootstrapper.construct(readerConfig, reader));
            }
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        throw new IllegalArgumentException("Can not create stream reader for given Stax2Source: neither InputStream nor Reader available");
    }

    protected XMLStreamReader2 constructSR(URL uRL, boolean bl) throws XMLStreamException {
        InputStream inputStream;
        try {
            inputStream = URLUtil.inputStreamFromURL(uRL);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        ReaderConfig readerConfig = this.getNonSharedConfig(URLUtil.urlToSystemId(uRL), null, null, bl, true);
        return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, inputStream));
    }

    protected XMLStreamReader2 constructSR(File file, boolean bl) throws XMLStreamException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            String string = URLUtil.fileToSystemId(file);
            ReaderConfig readerConfig = this.getNonSharedConfig(string, null, null, bl, true);
            return StreamReaderImpl.construct(ByteSourceBootstrapper.construct(readerConfig, fileInputStream));
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public XMLEventReader2 constructER(XMLStreamReader2 xMLStreamReader2) {
        return new EventReaderImpl(this.createEventAllocator(), xMLStreamReader2);
    }

    protected XMLEventAllocator createEventAllocator() {
        if (this._allocator != null) {
            return this._allocator.newInstance();
        }
        return this._config.willPreserveLocation() ? EventAllocatorImpl.getDefaultInstance() : EventAllocatorImpl.getFastInstance();
    }
}

