/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.ByteXmlWriter;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public abstract class SingleByteXmlWriter
extends ByteXmlWriter {
    public SingleByteXmlWriter(WriterConfig writerConfig, OutputStream outputStream, XmlCharTypes xmlCharTypes) {
        super(writerConfig, outputStream, xmlCharTypes);
    }

    @Override
    public abstract int getHighestEncodable();

    @Override
    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    @Override
    protected final void output2ByteChar(int n) throws IOException, XMLStreamException {
        this.reportFailedEscaping("content", n);
    }

    @Override
    protected final int outputStrictMultiByteChar(int n, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        this.reportFailedEscaping("content", n);
        return 0;
    }

    @Override
    protected final int outputMultiByteChar(int n, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (n >= 55296) {
            if (n <= 57343) {
                if (n2 >= n3) {
                    this.mSurrogate = n;
                } else {
                    char c = cArray[n2++];
                    this.outputSurrogates(n, c);
                }
                return n2;
            }
            if (n >= 65534) {
                this.reportInvalidChar(n);
            }
        }
        this.writeAsEntity(n);
        return n2;
    }

    @Override
    protected final void outputSurrogates(int n, int n2) throws IOException, XMLStreamException {
        this.writeAsEntity(this.calcSurrogate(n, n2, " in content"));
    }
}

