/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.ByteWName;
import com.fasterxml.aalto.out.OutputCharTypes;
import com.fasterxml.aalto.out.SingleByteXmlWriter;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class AsciiXmlWriter
extends SingleByteXmlWriter {
    static final int LAST_VALID_CHAR = 127;

    public AsciiXmlWriter(WriterConfig writerConfig, OutputStream outputStream) {
        super(writerConfig, outputStream, OutputCharTypes.getAsciiCharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 127;
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null || n2 == 0) {
            return;
        }
        if (this.mSurrogate != 0) {
            this.outputSurrogates(this.mSurrogate, cArray[n]);
            ++n;
            --n2;
        }
        n2 += n;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) > '\u007f') {
                this.reportFailedEscaping("raw content", c);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c;
        }
    }

    @Override
    protected WName doConstructName(String string) throws XMLStreamException {
        return new ByteWName(string, AsciiXmlWriter.getAscii(string));
    }

    @Override
    protected WName doConstructName(String string, String string2) throws XMLStreamException {
        int n = string.length();
        byte[] byArray = new byte[n + 1 + string2.length()];
        AsciiXmlWriter.getAscii(string, byArray, 0);
        byArray[n] = 58;
        AsciiXmlWriter.getAscii(string2, byArray, n + 1);
        return new ByteWName(string, string2, byArray);
    }
}

