/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public abstract class StreamScanner
extends ByteBasedScanner {
    protected InputStream _in;
    protected byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;

    public StreamScanner(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n, int n2) {
        super(readerConfig);
        this._in = inputStream;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n2;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullBBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected abstract int handleEntityInText(boolean var1) throws XMLStreamException;

    protected abstract String parsePublicId(byte var1) throws XMLStreamException;

    protected abstract String parseSystemId(byte var1) throws XMLStreamException;

    @Override
    public final int nextFromProlog(boolean bl) throws XMLStreamException {
        byte by;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return -1;
            }
            if ((by = this._inputBuffer[this._inputPtr++] & 0xFF) == 60) break;
            if (by == 32) continue;
            if (by == 10) {
                this.markLF();
                continue;
            }
            if (by == 13) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (by == 9) continue;
            this.reportPrologUnexpChar(bl, this.decodeCharForError(by), null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((by = this._inputBuffer[this._inputPtr++]) == 33) {
            return this.handlePrologDeclStart(bl);
        }
        if (by == 63) {
            return this.handlePIStart();
        }
        if (by == 47 || !bl) {
            this.reportPrologUnexpChar(bl, this.decodeCharForError(by), " (unbalanced start/end tags?)");
        }
        return this.handleStartElement(by);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                this._textBuilder.resetWithEmpty();
                return this._currToken;
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._textBuilder.resetWithEmpty();
            this._entityPending = false;
            return 9;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return -1;
        }
        byte by = this._inputBuffer[this._inputPtr];
        if (by == 60) {
            ++this._inputPtr;
            byte by2 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (by == 33) {
                return this.handleCommentOrCdataStart();
            }
            if (by == 63) {
                return this.handlePIStart();
            }
            if (by == 47) {
                return this.handleEndElement();
            }
            return this.handleStartElement(by);
        }
        if (by == 38) {
            ++this._inputPtr;
            int n = this.handleEntityInText(false);
            if (n == 0) {
                this._currToken = 9;
                return 9;
            }
            this._tmpChar = -n;
        } else {
            this._tmpChar = by & 0xFF;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    private final int handlePrologDeclStart(boolean bl) throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) == 45) {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (by == 68 && bl) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(bl, this.decodeCharForError(by), " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        byte by = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(by);
        by = this.skipInternalWs(false, null);
        if (by == 80) {
            this.matchAsciiKeyword("PUBLIC");
            by = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(by);
            by = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(by);
            by = this.skipInternalWs(false, null);
        } else if (by == 83) {
            this.matchAsciiKeyword("SYSTEM");
            by = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(by);
            by = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (by == 62) {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (by != 91) {
            String string = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(this.decodeCharForError(by), string);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    private final int handleCommentOrCdataStart() throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(by), " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (by == 91) {
            this._currToken = 12;
            for (int i = 0; i < 6; ++i) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                int n = this.decodeCharForError(by);
                this.reportTreeUnexpChar(n, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(this.decodeCharForError(by), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    private final int handlePIStart() throws XMLStreamException {
        int n;
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte by = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(by);
        String string = this._tokenName.getLocalName();
        if (string.length() == 3 && string.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) {
            while (true) {
                if (n == 10) {
                    this.markLF();
                } else if (n == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (n != 32 && n != 9) {
                    this.throwInvalidSpace(n);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((n = this._inputBuffer[this._inputPtr] & 0xFF) > 32) break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (n != 63) {
                this.reportMissingPISpace(this.decodeCharForError((byte)n));
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportMissingPISpace(this.decodeCharForError(by));
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte by = this._inputBuffer[this._inputPtr++];
        int n = 0;
        if (by == 120) {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by = this._inputBuffer[this._inputPtr++]) != 59) {
                    n <<= 4;
                    byte by2 = by;
                    if (by2 <= 57 && by2 >= 48) {
                        n += by2 - 48;
                    } else if (by2 >= 97 && by2 <= 102) {
                        n += 10 + (by2 - 97);
                    } else if (by2 >= 65 && by2 <= 70) {
                        n += 10 + (by2 - 65);
                    } else {
                        this.throwUnexpectedChar(this.decodeCharForError(by), "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (n <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (by != 59) {
                byte by3 = by;
                if (by3 <= 57 && by3 >= 48) {
                    if ((n = n * 10 + (by3 - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(this.decodeCharForError(by), "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                by = this._inputBuffer[this._inputPtr++];
            }
        }
        this.verifyXmlChar(n);
        return n;
    }

    protected abstract int handleStartElement(byte var1) throws XMLStreamException;

    protected final int handleEndElement() throws XMLStreamException {
        int n;
        int n2;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        int n3 = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (n3 << 2) + 1) {
            return this.handleEndElementSlow(n3);
        }
        int n4 = this._inputPtr;
        byte[] byArray = this._inputBuffer;
        --n3;
        for (n2 = 0; n2 < n3; ++n2) {
            n = byArray[n4] << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
            n4 += 4;
            if (n == this._tokenName.getQuad(n2)) continue;
            this._inputPtr = n4;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        n2 = this._tokenName.getQuad(n3);
        if ((n = byArray[n4++] & 0xFF) != n2 && (n = n << 8 | byArray[n4++] & 0xFF) != n2 && (n = n << 8 | byArray[n4++] & 0xFF) != n2 && (n = n << 8 | byArray[n4++] & 0xFF) != n2) {
            this._inputPtr = n4;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int n5 = this._inputBuffer[n4] & 0xFF;
        this._inputPtr = n4 + 1;
        while (n5 <= 32) {
            if (n5 == 10) {
                this.markLF();
            } else if (n5 == 13) {
                byte by;
                byte by2 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by != 10) {
                    this.markLF(this._inputPtr - 1);
                    n5 = by & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (n5 != 32 && n5 != 9) {
                this.throwInvalidSpace(n5);
            }
            n5 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (n5 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)n5), " expected space or closing '>'");
        }
        return 2;
    }

    private final int handleEndElementSlow(int n) throws XMLStreamException {
        block14: {
            int n2;
            int n3;
            int n4;
            --n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = 0;
                for (n2 = 0; n2 < 4; ++n2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    n3 = n3 << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                }
                if (n3 == this._tokenName.getQuad(n4)) continue;
                this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
            }
            n4 = this._tokenName.getQuad(n);
            n3 = 0;
            n2 = 0;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((n3 = n3 << 8 | this._inputBuffer[this._inputPtr++] & 0xFF) == n4) break block14;
            } while (++n2 <= 3);
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n5 = this._inputBuffer[this._inputPtr++];
        while (n5 <= 32) {
            if (n5 == 10) {
                this.markLF();
            } else if (n5 == 13) {
                byte by;
                byte by2 = by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by != 10) {
                    this.markLF(this._inputPtr - 1);
                    n5 = by & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (n5 != 32 && n5 != 9) {
                this.throwInvalidSpace(n5);
            }
            n5 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (n5 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)n5), " expected space or closing '>'");
        }
        return 2;
    }

    protected final PName parsePName(byte by) throws XMLStreamException {
        int n;
        if (this._inputEnd - this._inputPtr < 8) {
            return this.parsePNameSlow(by);
        }
        int n2 = by & 0xFF;
        if (n2 < 65) {
            this.throwUnexpectedChar(n2, "; expected a name start character");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 1);
        }
        n2 = n2 << 8 | n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 2);
        }
        n2 = n2 << 8 | n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 3);
        }
        n2 = n2 << 8 | n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 4);
        }
        return this.parsePNameMedium(n, n2);
    }

    protected PName parsePNameMedium(int n, int n2) throws XMLStreamException {
        int n3 = n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 1);
        }
        n3 = n3 << 8 | n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 2);
        }
        n3 = n3 << 8 | n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 3);
        }
        n3 = n3 << 8 | n;
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 4);
        }
        int[] nArray = this._quadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        return this.parsePNameLong(n, nArray);
    }

    protected final PName parsePNameLong(int n, int[] nArray) throws XMLStreamException {
        int n2 = 2;
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 1);
            }
            n = n << 8 | n3;
            n3 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n3 < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 2);
            }
            n = n << 8 | n3;
            n3 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n3 < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 3);
            }
            n = n << 8 | n3;
            n3 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n3 < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 4);
            }
            if (n2 >= nArray.length) {
                nArray = DataUtil.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n2] = n;
            ++n2;
            n = n3;
        }
    }

    protected final PName parsePNameSlow(byte by) throws XMLStreamException {
        int n = by & 0xFF;
        if (n < 65) {
            this.throwUnexpectedChar(n, "; expected a name start character");
        }
        int[] nArray = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 1, n3, n2, nArray);
            }
            n = n << 8 | n4;
            n4 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 2, n3, n2, nArray);
            }
            n = n << 8 | n4;
            n4 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 3, n3, n2, nArray);
            }
            n = n << 8 | n4;
            n4 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 4, n3, n2, nArray);
            }
            if (n2 == 0) {
                n3 = n;
            } else if (n2 == 1) {
                nArray[0] = n3;
                nArray[1] = n;
            } else {
                if (n2 >= nArray.length) {
                    this._quadBuffer = nArray = DataUtil.growArrayBy(nArray, nArray.length);
                }
                nArray[n2] = n;
            }
            ++n2;
            n = n4;
        }
    }

    private final PName findPName(int n, int n2) throws XMLStreamException {
        --this._inputPtr;
        int n3 = ByteBasedPNameTable.calcHash(n);
        PName pName = this._symbols.findSymbol(n3, n, 0);
        if (pName == null) {
            this._quadBuffer[0] = n;
            pName = this.addPName(n3, this._quadBuffer, 1, n2);
        }
        return pName;
    }

    private final PName findPName(int n, int n2, int n3) throws XMLStreamException {
        --this._inputPtr;
        int n4 = ByteBasedPNameTable.calcHash(n, n2);
        PName pName = this._symbols.findSymbol(n4, n, n2);
        if (pName == null) {
            this._quadBuffer[0] = n;
            this._quadBuffer[1] = n2;
            pName = this.addPName(n4, this._quadBuffer, 2, n3);
        }
        return pName;
    }

    private final PName findPName(int n, int[] nArray, int n2, int n3) throws XMLStreamException {
        --this._inputPtr;
        if (n2 >= nArray.length) {
            nArray = DataUtil.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = n;
        int n4 = ByteBasedPNameTable.calcHash(nArray, n2);
        PName pName = this._symbols.findSymbol(n4, nArray, n2);
        if (pName == null) {
            pName = this.addPName(n4, nArray, n2, n3);
        }
        return pName;
    }

    private final PName findPName(int n, int n2, int n3, int n4, int[] nArray) throws XMLStreamException {
        if (n4 <= 1) {
            if (n4 == 0) {
                return this.findPName(n, n2);
            }
            return this.findPName(n3, n, n2);
        }
        return this.findPName(n, nArray, n4, n2);
    }

    protected byte skipInternalWs(boolean bl, String string) throws XMLStreamException {
        byte by;
        int n;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n = (by = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) {
            if (!bl) {
                return by;
            }
            this.reportTreeUnexpChar(this.decodeCharForError(by), " (expected white space " + string + ")");
        }
        do {
            if (by == 10) {
                this.markLF();
            } else if (by == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (by != 32 && by != 9) {
                this.throwInvalidSpace(by);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while (((by = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
        return by;
    }

    private final void matchAsciiKeyword(String string) throws XMLStreamException {
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by = this._inputBuffer[this._inputPtr++]) == (byte)string.charAt(i)) continue;
            this.reportTreeUnexpChar(this.decodeCharForError(by), " (expected '" + string.charAt(i) + "' for " + string + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(int n) throws XMLStreamException {
        int n2;
        int n3;
        byte by;
        if (n == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by = this._inputBuffer[this._inputPtr]) != 32 && by != 9) {
            if (by == 60 && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != 33) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n4 = n3 = by == 32 ? 32 : 8;
        for (n2 = 1; n2 <= n3; ++n2) {
            byte by2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr]) != by) {
                if (by2 != 60 || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == 33) break;
                this._textBuilder.resetWithIndentation(n2, (char)by);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] cArray = this._textBuilder.resetWithEmpty();
        cArray[0] = 10;
        char c = (char)by;
        for (int i = 1; i <= n2; ++i) {
            cArray[i] = c;
        }
        this._textBuilder.setCurrentLength(++n2);
        return n2;
    }

    protected final int checkPrologIndentation(int n) throws XMLStreamException {
        int n2;
        if (n == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        byte by = this._inputBuffer[this._inputPtr];
        if (by != 32 && by != 9) {
            if (by == 60) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n3 = 1;
        int n4 = n2 = by == 32 ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == by) {
            ++this._inputPtr;
            if (++n3 < n2) continue;
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            char c = (char)by;
            for (int i = 1; i <= n3; ++i) {
                cArray[i] = c;
            }
            this._textBuilder.setCurrentLength(++n3);
            return n3;
        }
        this._textBuilder.resetWithIndentation(n3, (char)by);
        return -1;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        this._pastBytes += this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        try {
            int n = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n < 1) {
                this._inputEnd = 0;
                if (n == 0) {
                    this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = n;
            return true;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected final byte nextByte(int n) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(n));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte nextByte() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne(int n) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(n));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int n) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytes += this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int n2 = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n2);
        this._inputPtr = 0;
        this._inputEnd = n2;
        try {
            do {
                int n3;
                int n4;
                if ((n4 = this._in.read(this._inputBuffer, n2, n3 = this._inputBuffer.length - n2)) < 1) {
                    if (n4 == 0) {
                        this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + n3);
                    }
                    return false;
                }
                this._inputEnd += n4;
            } while (this._inputEnd < n);
            return true;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }
}

