/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.NsBinding;

public final class NsDeclaration {
    private final NsBinding mBinding;
    private final String mPreviousURI;
    private final NsDeclaration mPrevDeclaration;
    private final int mLevel;

    public NsDeclaration(NsBinding nsBinding, String string, NsDeclaration nsDeclaration, int n) {
        this.mBinding = nsBinding;
        this.mPrevDeclaration = nsDeclaration;
        this.mLevel = n;
        this.mPreviousURI = nsBinding.mURI;
        nsBinding.mURI = string;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public NsDeclaration getPrev() {
        return this.mPrevDeclaration;
    }

    public NsBinding getBinding() {
        return this.mBinding;
    }

    public String getPrefix() {
        return this.mBinding.mPrefix;
    }

    public String getCurrNsURI() {
        return this.mBinding.mURI;
    }

    public boolean hasPrefix(String string) {
        return string.equals(this.mBinding.mPrefix);
    }

    public boolean hasNsURI(String string) {
        return string.equals(this.mBinding.mURI);
    }

    public NsDeclaration unbind() {
        this.mBinding.mURI = this.mPreviousURI;
        return this.mPrevDeclaration;
    }

    public boolean alreadyDeclared(String string, int n) {
        if (this.mLevel >= n) {
            if (string == this.mBinding.mPrefix) {
                return true;
            }
            NsDeclaration nsDeclaration = this.mPrevDeclaration;
            while (nsDeclaration != null && nsDeclaration.mLevel >= n) {
                if (string == nsDeclaration.mBinding.mPrefix) {
                    return true;
                }
                nsDeclaration = nsDeclaration.mPrevDeclaration;
            }
        }
        return false;
    }

    public int countDeclsOnLevel(int n) {
        int n2 = 0;
        if (this.mLevel == n) {
            ++n2;
            NsDeclaration nsDeclaration = this.mPrevDeclaration;
            while (nsDeclaration != null && nsDeclaration.mLevel == n) {
                ++n2;
                nsDeclaration = nsDeclaration.mPrevDeclaration;
            }
        }
        return n2;
    }

    public String toString() {
        return "[NS-DECL, prefix = <" + this.mBinding.mPrefix + ">, current URI <" + this.mBinding.mURI + ">, level " + this.mLevel + ", prev URI <" + this.mPreviousURI + ">]";
    }
}

