/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.InputBootstrapper;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.ReaderScanner;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.CharsetNames;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public final class CharSourceBootstrapper
extends InputBootstrapper {
    static final int DEFAULT_BUFFER_SIZE = 4000;
    static final char CHAR_BOM_MARKER = '\ufeff';
    final Reader _in;
    final char[] _inputBuffer;
    private int _inputPtr;
    private int _inputLast;

    private CharSourceBootstrapper(ReaderConfig readerConfig, Reader reader) {
        super(readerConfig);
        this._in = reader;
        this._inputBuffer = readerConfig.allocFullCBuffer(4000);
        this._inputPtr = 0;
        this._inputLast = 0;
    }

    private CharSourceBootstrapper(ReaderConfig readerConfig, char[] cArray, int n, int n2) {
        super(readerConfig);
        this._in = null;
        this._inputBuffer = cArray;
        this._inputPtr = n;
        this._inputLast = n + n2;
    }

    public static CharSourceBootstrapper construct(ReaderConfig readerConfig, Reader reader) throws XMLStreamException {
        return new CharSourceBootstrapper(readerConfig, reader);
    }

    public static CharSourceBootstrapper construct(ReaderConfig readerConfig, char[] cArray, int n, int n2) throws XMLStreamException {
        return new CharSourceBootstrapper(readerConfig, cArray, n, n2);
    }

    @Override
    public XmlScanner doBootstrap() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLast) {
            this.initialLoad(7);
        }
        String string = null;
        if (this._inputLast - this._inputPtr >= 7) {
            char c = this._inputBuffer[this._inputPtr];
            if (c == '\ufeff') {
                c = this._inputBuffer[++this._inputPtr];
            }
            if (c == '<') {
                if (this._inputBuffer[this._inputPtr + 1] == '?' && this._inputBuffer[this._inputPtr + 2] == 'x' && this._inputBuffer[this._inputPtr + 3] == 'm' && this._inputBuffer[this._inputPtr + 4] == 'l' && this._inputBuffer[this._inputPtr + 5] <= ' ') {
                    this._inputPtr += 6;
                    this.readXmlDeclaration();
                    if (this.mFoundEncoding != null) {
                        string = this.verifyXmlEncoding(this.mFoundEncoding);
                    }
                }
            } else if (c == '\u00ef') {
                throw new IoStreamException("Unexpected first character (char code 0xEF), not valid in xml document: could be mangled UTF-8 BOM marker. Make sure that the Reader uses correct encoding or pass an InputStream instead");
            }
        }
        this._config.setActualEncoding(string);
        this._config.setXmlDeclInfo(this.mDeclaredXmlVersion, this.mFoundEncoding, this.mStandalone);
        return new ReaderScanner(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLast);
    }

    protected String verifyXmlEncoding(String string) throws XMLStreamException {
        XMLReporter xMLReporter;
        string = CharsetNames.normalize(string);
        String string2 = this._config.getExternalEncoding();
        if (string2 != null && string != null && !string2.equalsIgnoreCase(string) && (xMLReporter = this._config.getXMLReporter()) != null) {
            Location location = this.getLocation();
            xMLReporter.report(MessageFormat.format(ErrorConsts.W_MIXED_ENCODINGS, string2, string), ErrorConsts.WT_XML_DECL, this, location);
        }
        return string;
    }

    protected boolean initialLoad(int n) throws IOException {
        this._inputPtr = 0;
        this._inputLast = 0;
        if (this._in == null) {
            return false;
        }
        while (this._inputLast < n) {
            int n2 = this._in.read(this._inputBuffer, this._inputLast, this._inputBuffer.length - this._inputLast);
            if (n2 < 1) {
                return false;
            }
            this._inputLast += n2;
        }
        return true;
    }

    protected void loadMore() throws IOException, XMLStreamException {
        this._inputProcessed += this._inputLast;
        this._inputRowStart -= this._inputLast;
        if (this._in == null) {
            this.reportEof();
        }
        this._inputPtr = 0;
        this._inputLast = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (this._inputLast < 1) {
            this.reportEof();
        }
    }

    @Override
    protected void pushback() {
        --this._inputPtr;
    }

    @Override
    protected int getNext() throws IOException, XMLStreamException {
        return this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
    }

    @Override
    protected int getNextAfterWs(boolean bl) throws IOException, XMLStreamException {
        int n = 0;
        while (true) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c > ' ') {
                if (bl && n == 0) {
                    this.reportUnexpectedChar(c, "; expected a white space");
                }
                return c;
            }
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.reportNull();
            }
            ++n;
        }
    }

    @Override
    protected int checkKeyword(String string) throws IOException, XMLStreamException {
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c != string.charAt(i)) {
                return c;
            }
            if (c != '\u0000') continue;
            this.reportNull();
        }
        return 0;
    }

    @Override
    protected int readQuotedValue(char[] cArray, int n) throws IOException, XMLStreamException {
        int n2 = 0;
        int n3 = cArray.length;
        while (true) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.reportNull();
            }
            if (c == n) {
                return n2 < n3 ? n2 : -1;
            }
            if (n2 >= n3) continue;
            cArray[n2++] = c;
        }
    }

    @Override
    protected Location getLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._inputProcessed + this._inputPtr, this._inputRow, this._inputPtr - this._inputRowStart);
    }

    protected char nextChar() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLast) {
            this.loadMore();
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected void skipCRLF(char c) throws IOException, XMLStreamException {
        if (c == '\r') {
            char c2;
            char c3 = c2 = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c2 != '\n') {
                --this._inputPtr;
            }
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }
}

