/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.util.NameTable;

public class CharBasedPNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    protected static final float DEFAULT_FILL_FACTOR = 0.75f;
    protected PNameC[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected boolean _dirty;

    public CharBasedPNameTable(int n) {
        int n2;
        this._dirty = true;
        if (n < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + n);
        }
        for (n2 = 16; n2 < n; n2 += n2) {
        }
        n = n2;
        this._symbols = new PNameC[n];
        this._buckets = new Bucket[n >> 1];
        this._indexMask = n - 1;
        this._size = 0;
        this._sizeThreshold = n * 3 + 3 >> 2;
    }

    CharBasedPNameTable(CharBasedPNameTable charBasedPNameTable) {
        this._symbols = charBasedPNameTable._symbols;
        this._buckets = charBasedPNameTable._buckets;
        this._size = charBasedPNameTable._size;
        this._sizeThreshold = charBasedPNameTable._sizeThreshold;
        this._indexMask = charBasedPNameTable._indexMask;
        this._dirty = false;
    }

    public synchronized void mergeFromChild(CharBasedPNameTable charBasedPNameTable) {
        if (charBasedPNameTable.size() <= this.size()) {
            return;
        }
        this._symbols = charBasedPNameTable._symbols;
        this._buckets = charBasedPNameTable._buckets;
        this._size = charBasedPNameTable._size;
        this._sizeThreshold = charBasedPNameTable._sizeThreshold;
        this._indexMask = charBasedPNameTable._indexMask;
        this._dirty = false;
        charBasedPNameTable._dirty = false;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean maybeDirty() {
        return this._dirty;
    }

    public PNameC findSymbol(char[] cArray, int n, int n2, int n3) {
        int n4 = n3 & this._indexMask;
        PNameC pNameC = this._symbols[n4];
        if (pNameC != null) {
            if (pNameC.equalsPName(cArray, n, n2, n3)) {
                return pNameC;
            }
            Bucket bucket = this._buckets[n4 >> 1];
            if (bucket != null && (pNameC = bucket.find(cArray, n, n2, n3)) != null) {
                return pNameC;
            }
        }
        return null;
    }

    public PNameC addSymbol(char[] cArray, int n, int n2, int n3) {
        boolean bl;
        String string = new String(cArray, n, n2).intern();
        PNameC pNameC = PNameC.construct(string, n3);
        int n4 = n3 & this._indexMask;
        if (null == this._symbols[n4]) {
            bl = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n4 = n3 & this._indexMask;
            bl = null == this._symbols[n4];
        } else {
            bl = false;
        }
        if (!this._dirty) {
            this.copyArrays();
        }
        ++this._size;
        if (bl) {
            this._symbols[n4] = pNameC;
        } else {
            int n5 = n4 >> 1;
            this._buckets[n5] = new Bucket(pNameC, this._buckets[n5]);
        }
        return pNameC;
    }

    private void copyArrays() {
        PNameC[] pNameCArray = this._symbols;
        int n = pNameCArray.length;
        this._symbols = new PNameC[n];
        System.arraycopy(pNameCArray, 0, this._symbols, 0, n);
        Bucket[] bucketArray = this._buckets;
        n = bucketArray.length;
        this._buckets = new Bucket[n];
        System.arraycopy(bucketArray, 0, this._buckets, 0, n);
        this._dirty = true;
    }

    private void rehash() {
        int n;
        Object object;
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        PNameC[] pNameCArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new PNameC[n4];
        this._buckets = new Bucket[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold += this._sizeThreshold;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            object = pNameCArray[n2];
            if (object == null) continue;
            ++n5;
            int n6 = ((PNameC)object).getCustomHash() & this._indexMask;
            if (this._symbols[n6] == null) {
                this._symbols[n6] = object;
                continue;
            }
            n = n6 >> 1;
            this._buckets[n] = new Bucket((PNameC)object, this._buckets[n]);
        }
        n3 >>= 1;
        for (n2 = 0; n2 < n3; ++n2) {
            for (object = bucketArray[n2]; object != null; object = ((Bucket)object).getNext()) {
                ++n5;
                PNameC pNameC = ((Bucket)object).getSymbol();
                n = pNameC.getCustomHash() & this._indexMask;
                if (this._symbols[n] == null) {
                    this._symbols[n] = pNameC;
                    continue;
                }
                int n7 = n >> 1;
                this._buckets[n7] = new Bucket(pNameC, this._buckets[n7]);
            }
        }
        if (n5 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n5 + ".");
        }
    }

    static final class Bucket {
        private final PNameC mSymbol;
        private final Bucket mNext;

        public Bucket(PNameC pNameC, Bucket bucket) {
            this.mSymbol = pNameC;
            this.mNext = bucket;
        }

        public PNameC getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public PNameC find(char[] cArray, int n, int n2, int n3) {
            Bucket bucket = this;
            do {
                PNameC pNameC;
                if (!(pNameC = bucket.mSymbol).equalsPName(cArray, n, n2, n3)) continue;
                return pNameC;
            } while ((bucket = bucket.getNext()) != null);
            return null;
        }
    }
}

