/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.ByteBasedPName;
import com.fasterxml.aalto.in.ByteBasedPNameFactory;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.util.NameTable;

public final class ByteBasedPNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private ByteBasedPName[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    public ByteBasedPNameTable(int n) {
        if (n < 16) {
            n = 16;
        } else if ((n & n - 1) != 0) {
            int n2;
            for (n2 = 16; n2 < n; n2 += n2) {
            }
            n = n2;
        }
        this.mCount = 0;
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = n - 1;
        this.mMainHash = new int[n];
        this.mMainNames = new ByteBasedPName[n];
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    ByteBasedPNameTable(ByteBasedPNameTable byteBasedPNameTable) {
        this.mCount = byteBasedPNameTable.mCount;
        this.mMainHashMask = byteBasedPNameTable.mMainHashMask;
        this.mMainHash = byteBasedPNameTable.mMainHash;
        this.mMainNames = byteBasedPNameTable.mMainNames;
        this.mCollList = byteBasedPNameTable.mCollList;
        this.mCollCount = byteBasedPNameTable.mCollCount;
        this.mCollEnd = byteBasedPNameTable.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public boolean mergeFromChild(ByteBasedPNameTable byteBasedPNameTable) {
        if (byteBasedPNameTable.mCount <= this.mCount) {
            return false;
        }
        this.mCount = byteBasedPNameTable.mCount;
        this.mMainHashMask = byteBasedPNameTable.mMainHashMask;
        this.mMainHash = byteBasedPNameTable.mMainHash;
        this.mMainNames = byteBasedPNameTable.mMainNames;
        this.mCollList = byteBasedPNameTable.mCollList;
        this.mCollCount = byteBasedPNameTable.mCollCount;
        this.mCollEnd = byteBasedPNameTable.mCollEnd;
        byteBasedPNameTable.markAsShared();
        return true;
    }

    public void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public void nuke() {
        this.mMainHash = null;
        this.mMainNames = null;
        this.mCollList = null;
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public ByteBasedPName findSymbol(int n, int n2, int n3) {
        Object object;
        int n4 = n & this.mMainHashMask;
        int n5 = this.mMainHash[n4];
        if ((n5 >> 8 ^ n) << 8 == 0) {
            object = this.mMainNames[n4];
            if (object == null) {
                return null;
            }
            if (((ByteBasedPName)object).equals(n2, n3)) {
                return object;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 &= 0xFF) > 0 && (object = this.mCollList[--n5]) != null) {
            return ((Bucket)object).find(n, n2, n3);
        }
        return null;
    }

    public ByteBasedPName findSymbol(int n, int[] nArray, int n2) {
        Object object;
        if (n2 < 3) {
            return this.findSymbol(n, nArray[0], n2 < 2 ? 0 : nArray[1]);
        }
        int n3 = n & this.mMainHashMask;
        int n4 = this.mMainHash[n3];
        if ((n4 >> 8 ^ n) << 8 == 0) {
            object = this.mMainNames[n3];
            if (object == null) {
                return null;
            }
            if (((ByteBasedPName)object).equals(nArray, n2)) {
                return object;
            }
        } else if (n4 == 0) {
            return null;
        }
        if ((n4 &= 0xFF) > 0 && (object = this.mCollList[--n4]) != null) {
            return ((Bucket)object).find(n, nArray, n2);
        }
        return null;
    }

    public ByteBasedPName addSymbol(int n, String string, int n2, int n3, int n4) {
        ByteBasedPName byteBasedPName = ByteBasedPNameFactory.getInstance().constructPName(n, string, n2, n3, n4);
        this.doAddSymbol(n, byteBasedPName);
        return byteBasedPName;
    }

    public ByteBasedPName addSymbol(int n, String string, int n2, int[] nArray, int n3) {
        ByteBasedPName byteBasedPName = ByteBasedPNameFactory.getInstance().constructPName(n, string, n2, nArray, n3);
        this.doAddSymbol(n, byteBasedPName);
        return byteBasedPName;
    }

    public static final int calcHash(int n) {
        int n2 = n * 31;
        n2 ^= n2 >>> 16;
        n2 ^= n2 >>> 8;
        return n2;
    }

    public static final int calcHash(int n, int n2) {
        int n3 = n * 31 + n2;
        n3 ^= n3 >>> 16;
        n3 ^= n3 >>> 8;
        return n3;
    }

    public static final int calcHash(int[] nArray, int n) {
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            n2 = n2 * 31 + nArray[i];
        }
        n2 ^= n2 >>> 16;
        n2 ^= n2 >>> 8;
        return n2;
    }

    public static int[] calcQuads(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[(n + 3) / 4];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (++i < n) {
                n2 = n2 << 8 | byArray[i] & 0xFF;
                if (++i < n) {
                    n2 = n2 << 8 | byArray[i] & 0xFF;
                    if (++i < n) {
                        n2 = n2 << 8 | byArray[i] & 0xFF;
                    }
                }
            }
            nArray[i >> 2] = n2;
        }
        return nArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.mCollCount);
        stringBuilder.append(" coll; avg length: ");
        int n = this.mCount;
        for (int i = 0; i < this.mCollEnd; ++i) {
            int n2 = this.mCollList[i].length();
            for (int j = 1; j <= n2; ++j) {
                n += j;
            }
        }
        double d = this.mCount == 0 ? 0.0 : (double)n / (double)this.mCount;
        stringBuilder.append(d);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toDebugString() {
        Object object;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(" -> ");
        for (n = 0; n < this.mMainHash.length; ++n) {
            stringBuilder.append("\n#");
            stringBuilder.append(n);
            stringBuilder.append(": 0x");
            stringBuilder.append(Integer.toHexString(this.mMainHash[n]));
            stringBuilder.append(" == ");
            object = this.mMainNames[n];
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append('\"');
            stringBuilder.append(((PName)object).toString());
            stringBuilder.append('\"');
        }
        stringBuilder.append("\nSpill(");
        stringBuilder.append(this.mCollEnd);
        stringBuilder.append("):");
        for (n = 0; n < this.mCollEnd; ++n) {
            object = this.mCollList[n];
            stringBuilder.append("\nsp#");
            stringBuilder.append(n);
            stringBuilder.append(": ");
            stringBuilder.append(((Bucket)object).toDebugString());
        }
        return stringBuilder.toString();
    }

    private void doAddSymbol(int n, ByteBasedPName byteBasedPName) {
        int n2;
        int n3;
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        ++this.mCount;
        int n4 = n & this.mMainHashMask;
        if (this.mMainNames[n4] == null) {
            this.mMainHash[n4] = n << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[n4] = byteBasedPName;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            n3 = this.mMainHash[n4];
            n2 = n3 & 0xFF;
            if (n2 == 0) {
                if (this.mCollEnd <= 254) {
                    if ((n2 = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    n2 = this.findBestBucket();
                }
                this.mMainHash[n4] = n3 & 0xFFFFFF00 | n2 + 1;
            } else {
                --n2;
            }
            this.mCollList[n2] = new Bucket(byteBasedPName, this.mCollList[n2]);
        }
        n3 = this.mMainHash.length;
        if (this.mCount > n3 >> 1) {
            n2 = n3 >> 2;
            if (this.mCount > n3 - n2) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= n2) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        int n;
        Bucket[] bucketArray;
        int n2;
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int n3 = 0;
        int[] nArray = this.mMainHash;
        int n4 = nArray.length;
        this.mMainHash = new int[n4 + n4];
        this.mMainHashMask = n4 + n4 - 1;
        ByteBasedPName[] byteBasedPNameArray = this.mMainNames;
        this.mMainNames = new ByteBasedPName[n4 + n4];
        for (n2 = 0; n2 < n4; ++n2) {
            bucketArray = byteBasedPNameArray[n2];
            if (bucketArray == null) continue;
            ++n3;
            n = bucketArray.hashCode();
            int n5 = n & this.mMainHashMask;
            this.mMainNames[n5] = bucketArray;
            this.mMainHash[n5] = n << 8;
        }
        n2 = this.mCollEnd;
        if (n2 == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        bucketArray = this.mCollList;
        this.mCollList = new Bucket[bucketArray.length];
        for (n = 0; n < n2; ++n) {
            Bucket bucket = bucketArray[n];
            while (bucket != null) {
                ++n3;
                ByteBasedPName byteBasedPName = bucket.mName;
                int n6 = byteBasedPName.hashCode();
                int n7 = n6 & this.mMainHashMask;
                int n8 = this.mMainHash[n7];
                if (this.mMainNames[n7] == null) {
                    this.mMainHash[n7] = n6 << 8;
                    this.mMainNames[n7] = byteBasedPName;
                } else {
                    ++this.mCollCount;
                    int n9 = n8 & 0xFF;
                    if (n9 == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((n9 = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n9 = this.findBestBucket();
                        }
                        this.mMainHash[n7] = n8 & 0xFFFFFF00 | n9 + 1;
                    } else {
                        --n9;
                    }
                    this.mCollList[n9] = new Bucket(byteBasedPName, this.mCollList[n9]);
                }
                bucket = bucket.mNext;
            }
        }
        if (n3 != this.mCount) {
            throw new Error("Internal error: count after rehash " + n3 + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this.mCollList;
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = this.mCollEnd;
        for (int i = 0; i < n3; ++i) {
            int n4 = bucketArray[i].length();
            if (n4 >= n) continue;
            if (n4 == 1) {
                return i;
            }
            n = n4;
            n2 = i;
        }
        return n2;
    }

    private void unshareMain() {
        int[] nArray = this.mMainHash;
        int n = this.mMainHash.length;
        this.mMainHash = new int[n];
        System.arraycopy(nArray, 0, this.mMainHash, 0, n);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] bucketArray = this.mCollList;
        if (bucketArray == null) {
            this.mCollList = new Bucket[32];
        } else {
            int n = bucketArray.length;
            this.mCollList = new Bucket[n];
            System.arraycopy(bucketArray, 0, this.mCollList, 0, n);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        ByteBasedPName[] byteBasedPNameArray = this.mMainNames;
        int n = byteBasedPNameArray.length;
        this.mMainNames = new ByteBasedPName[n];
        System.arraycopy(byteBasedPNameArray, 0, this.mMainNames, 0, n);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] bucketArray = this.mCollList;
        int n = bucketArray.length;
        this.mCollList = new Bucket[n + n];
        System.arraycopy(bucketArray, 0, this.mCollList, 0, n);
    }

    static final class Bucket {
        final ByteBasedPName mName;
        final Bucket mNext;

        Bucket(ByteBasedPName byteBasedPName, Bucket bucket) {
            this.mName = byteBasedPName;
            this.mNext = bucket;
        }

        public int length() {
            int n = 1;
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ++n;
                bucket = bucket.mNext;
            }
            return n;
        }

        public ByteBasedPName find(int n, int n2, int n3) {
            if (this.mName.hashCode() == n && this.mName.equals(n2, n3)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ByteBasedPName byteBasedPName = bucket.mName;
                if (byteBasedPName.hashCode() == n && byteBasedPName.equals(n2, n3)) {
                    return byteBasedPName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public ByteBasedPName find(int n, int[] nArray, int n2) {
            if (this.mName.hashCode() == n && this.mName.equals(nArray, n2)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ByteBasedPName byteBasedPName = bucket.mName;
                if (byteBasedPName.hashCode() == n && byteBasedPName.equals(nArray, n2)) {
                    return byteBasedPName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public String toDebugString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[Bucket(");
            stringBuilder.append(this.length());
            stringBuilder.append("): ");
            Bucket bucket = this;
            while (bucket != null) {
                stringBuilder.append('\"');
                stringBuilder.append(bucket.mName.toString());
                stringBuilder.append("\" -> ");
                bucket = bucket.mNext;
            }
            stringBuilder.append("NULL]");
            return stringBuilder.toString();
        }
    }
}

