/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services.results_export;

import com.farao_community.farao.data.crac_api.Contingency;
import com.farao_community.farao.gridcapa_core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResult;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.ResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.minio_adapter.starter.MinioAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RexResultFileExporter
implements ResultFileExporter {
    private static final String REX_SAMPLE_CSV_FILE = "outputs/%s-ValidationCORE-REX-v[v].csv";
    private static final Logger LOGGER = LoggerFactory.getLogger(RexResultFileExporter.class);
    private final MinioAdapter minioAdapter;

    public RexResultFileExporter(MinioAdapter minioAdapter) {
        this.minioAdapter = minioAdapter;
    }

    public String exportStudyPointResult(List<StudyPointResult> studyPointResults, OffsetDateTime timestamp) {
        ByteArrayOutputStream rexResultBaos = new ByteArrayOutputStream();
        try {
            CSVPrinter rexResultCsvPrinter = new CSVPrinter((Appendable)new OutputStreamWriter(rexResultBaos), CSVFormat.EXCEL.withDelimiter(';').withHeader(new String[]{"Period", "Vertice ID", "Branch ID", "Branch Name", "Outage Name", "Branch Status", "RAM before", "RAM after", "flow before", "flow after"}));
            for (StudyPointResult studyPointResult : studyPointResults) {
                this.addStudyPointResultToRexOutputFile(studyPointResult, rexResultCsvPrinter);
            }
            rexResultCsvPrinter.flush();
            rexResultCsvPrinter.close();
        }
        catch (IOException e) {
            throw new CoreValidInvalidDataException("Error during export of studypoint results on Minio", (Throwable)e);
        }
        String filePath = this.getFormattedFilename(REX_SAMPLE_CSV_FILE, timestamp, this.minioAdapter);
        ByteArrayInputStream inStream = new ByteArrayInputStream(rexResultBaos.toByteArray());
        this.minioAdapter.uploadOutput(filePath, (InputStream)inStream);
        LOGGER.info("Rex result file was successfully uploaded on minIO");
        return this.minioAdapter.generatePreSignedUrl(filePath);
    }

    private void addStudyPointResultToRexOutputFile(StudyPointResult studyPointResult, CSVPrinter csvPrinter) throws IOException {
        for (LimitingBranchResult limitingBranchResult : studyPointResult.getListLimitingBranchResult()) {
            this.addLimitingBranchResultToRexOutputFile(limitingBranchResult, studyPointResult, csvPrinter);
        }
    }

    private void addLimitingBranchResultToRexOutputFile(LimitingBranchResult limitingBranchResult, StudyPointResult studyPointResult, CSVPrinter csvPrinter) throws IOException {
        ArrayList<String> mainResultFields = new ArrayList<String>();
        mainResultFields.add(studyPointResult.getPeriod());
        mainResultFields.add(studyPointResult.getId());
        mainResultFields.add(limitingBranchResult.getCriticalBranchId());
        mainResultFields.add(limitingBranchResult.getCriticalBranchName());
        Optional optionalContingency = limitingBranchResult.getState().getContingency();
        if (optionalContingency.isPresent()) {
            mainResultFields.add(((Contingency)optionalContingency.get()).getName());
        } else {
            mainResultFields.add("");
        }
        mainResultFields.add(limitingBranchResult.getBranchStatus());
        mainResultFields.add(String.valueOf(Math.round(limitingBranchResult.getRamBefore())));
        mainResultFields.add(String.valueOf(Math.round(limitingBranchResult.getRamAfter())));
        mainResultFields.add(String.valueOf(Math.round(limitingBranchResult.getFlowBefore())));
        mainResultFields.add(String.valueOf(Math.round(limitingBranchResult.getFlowAfter())));
        csvPrinter.printRecord(mainResultFields);
    }
}

