/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services.results_export;

import com.farao_community.farao.gridcapa_core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResult;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.ResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.minio_adapter.starter.MinioAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MainResultFileExporter
implements ResultFileExporter {
    private static final String MAIN_SAMPLE_CSV_FILE = "outputs/%s-ValidationCORE-v[v].csv";
    private static final Logger LOGGER = LoggerFactory.getLogger(MainResultFileExporter.class);
    private final MinioAdapter minioAdapter;

    public MainResultFileExporter(MinioAdapter minioAdapter) {
        this.minioAdapter = minioAdapter;
    }

    public String exportStudyPointResult(List<StudyPointResult> studyPointResults, OffsetDateTime timestamp) {
        ByteArrayOutputStream mainResultBaos = new ByteArrayOutputStream();
        try {
            CSVPrinter mainResultCsvPrinter = new CSVPrinter((Appendable)new OutputStreamWriter(mainResultBaos), CSVFormat.EXCEL.withDelimiter(';').withHeader(new String[]{"Period", "Vertice ID", "Branch ID", "Branch Status", "RAM before", "RAM after"}));
            for (StudyPointResult studyPointResult : studyPointResults) {
                this.addStudyPointResultToMainOutputFile(studyPointResult, mainResultCsvPrinter);
            }
            mainResultCsvPrinter.flush();
            mainResultCsvPrinter.close();
        }
        catch (IOException e) {
            throw new CoreValidInvalidDataException("Error during export of studypoint results on Minio", (Throwable)e);
        }
        String filePath = this.getFormattedFilename(MAIN_SAMPLE_CSV_FILE, timestamp, this.minioAdapter);
        ByteArrayInputStream inStream = new ByteArrayInputStream(mainResultBaos.toByteArray());
        this.minioAdapter.uploadOutput(filePath, (InputStream)inStream);
        LOGGER.info("Main result file was successfully uploaded on minIO");
        return this.minioAdapter.generatePreSignedUrl(filePath);
    }

    private void addStudyPointResultToMainOutputFile(StudyPointResult studyPointResult, CSVPrinter csvPrinter) throws IOException {
        for (LimitingBranchResult limitingBranchResult : studyPointResult.getListLimitingBranchResult()) {
            this.addLimitingBranchResultToMainOutputFile(limitingBranchResult, studyPointResult, csvPrinter);
        }
    }

    private void addLimitingBranchResultToMainOutputFile(LimitingBranchResult limitingBranchResult, StudyPointResult studyPointResult, CSVPrinter csvPrinter) throws IOException {
        ArrayList<String> mainResultFields = new ArrayList<String>();
        mainResultFields.add(studyPointResult.getPeriod());
        mainResultFields.add(studyPointResult.getId());
        mainResultFields.add(limitingBranchResult.getCriticalBranchId());
        mainResultFields.add(limitingBranchResult.getBranchStatus());
        mainResultFields.add(String.valueOf(Math.round(limitingBranchResult.getRamBefore())));
        mainResultFields.add(String.valueOf(Math.round(limitingBranchResult.getRamAfter())));
        csvPrinter.printRecord(mainResultFields);
    }
}

