/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services;

import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.data.refprog.reference_program.ReferenceProgram;
import com.farao_community.farao.gridcapa_core_valid.app.CoreAreasId;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.powsybl.action.util.Scalable;
import com.powsybl.glsk.commons.CountryEICode;
import com.powsybl.glsk.commons.ZonalData;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Network;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public final class NetPositionsHandler {
    private NetPositionsHandler() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, Double> computeCoreReferenceNetPositions(ReferenceProgram referenceProgram) {
        TreeMap<String, Double> coreNetPositions = new TreeMap<String, Double>();
        referenceProgram.getReferenceExchangeDataList().forEach(referenceExchangeData -> {
            String areaIn = referenceExchangeData.getAreaIn().toString();
            String areaOut = referenceExchangeData.getAreaOut().toString();
            if (CoreAreasId.ID_MAPPING.containsValue(areaIn) && CoreAreasId.ID_MAPPING.containsValue(areaOut)) {
                coreNetPositions.put(areaIn, coreNetPositions.getOrDefault(areaIn, 0.0) - referenceExchangeData.getFlow());
                coreNetPositions.put(areaOut, coreNetPositions.getOrDefault(areaOut, 0.0) + referenceExchangeData.getFlow());
            }
        });
        return coreNetPositions;
    }

    public static void shiftNetPositionToStudyPoint(Network network, StudyPoint studyPoint, ZonalData<Scalable> scalableZonalData, Map<String, Double> coreNetPositions) {
        studyPoint.getPositions().forEach((studyPointZoneId, netPosition) -> {
            try {
                if (studyPointZoneId.equals("NP_BE_ALEGrO")) {
                    Optional<DanglingLine> danglingLine = network.getDanglingLineStream().filter(dl -> dl.getUcteXnodeCode().equals("XLI_OB1B")).findAny();
                    danglingLine.ifPresent(dl -> dl.setP0(netPosition.doubleValue()));
                } else if (studyPointZoneId.equals("NP_DE_ALEGrO")) {
                    Optional<DanglingLine> danglingLine = network.getDanglingLineStream().filter(dl -> dl.getUcteXnodeCode().equals("XLI_OB1A")).findAny();
                    danglingLine.ifPresent(dl -> dl.setP0(netPosition.doubleValue()));
                } else {
                    String zone = (String)CoreAreasId.ID_MAPPING.get(studyPointZoneId);
                    double shift = netPosition - coreNetPositions.getOrDefault(zone, 0.0);
                    String zoneEiCode = new CountryEICode(Country.valueOf((String)zone)).getCode();
                    Scalable scalable = (Scalable)scalableZonalData.getData(zoneEiCode);
                    if (scalable != null) {
                        scalable.scale(network, shift);
                    }
                }
            }
            catch (Exception e) {
                throw new CoreValidInternalException("Error during the net position shift for zone " + (String)CoreAreasId.ID_MAPPING.get(studyPointZoneId), (Throwable)e);
            }
        });
    }
}

