/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.exception.CoreValidRaoException;
import com.farao_community.farao.core_valid.api.resource.CoreValidRequest;
import com.farao_community.farao.core_valid.api.resource.CoreValidResponse;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.crac_creator.FbConstraintCreationContext;
import com.farao_community.farao.data.refprog.reference_program.ReferenceProgram;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.SearchTreeRaoConfiguration;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileImporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.ResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointData;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.farao_community.farao.minio_adapter.starter.MinioAdapter;
import com.farao_community.farao.rao_api.parameters.RaoParameters;
import com.farao_community.farao.rao_runner.api.resource.RaoRequest;
import com.farao_community.farao.rao_runner.api.resource.RaoResponse;
import com.farao_community.farao.search_tree_rao.castor.parameters.SearchTreeRaoParameters;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.glsk.api.GlskDocument;
import com.powsybl.glsk.commons.ZonalData;
import com.powsybl.iidm.network.Network;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class CoreValidHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreValidHandler.class);
    private final Logger eventsLogger;
    private final FileExporter fileExporter;
    private final FileImporter fileImporter;
    private final MinioAdapter minioAdapter;
    private final SearchTreeRaoConfiguration searchTreeRaoConfiguration;
    private final StudyPointService studyPointService;
    private final DateTimeFormatter artifactsFormatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmm");
    private final DateTimeFormatter timestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd' 'HH:mm");
    private final Map<StudyPoint, CompletableFuture<RaoResponse>> studyPointCompletableFutures = new HashMap();
    private final Map<StudyPoint, RaoRequest> studyPointRaoRequests = new HashMap();
    private final List<StudyPointResult> studyPointResults = new ArrayList();
    private Instant computationStartInstant;
    private Instant computationEndInstant;
    private String formattedTimestamp;
    private List<StudyPoint> studyPoints;
    private Map<ResultFileExporter.ResultType, String> resultFileUrls;

    public CoreValidHandler(StudyPointService studyPointService, FileImporter fileImporter, FileExporter fileExporter, SearchTreeRaoConfiguration searchTreeRaoConfiguration, MinioAdapter minioAdapter, Logger eventsLogger) {
        this.studyPointService = studyPointService;
        this.fileImporter = fileImporter;
        this.fileExporter = fileExporter;
        this.searchTreeRaoConfiguration = searchTreeRaoConfiguration;
        this.minioAdapter = minioAdapter;
        this.eventsLogger = eventsLogger;
    }

    public CoreValidResponse handleCoreValidRequest(CoreValidRequest coreValidRequest) {
        try {
            this.preTreatment(coreValidRequest);
            this.computeStudyPoints(coreValidRequest);
            this.postTreatment(coreValidRequest);
        }
        catch (InterruptedException e) {
            this.eventsLogger.error("Error during core request running for timestamp {}.", (Object)this.formattedTimestamp);
            Thread.currentThread().interrupt();
            throw new CoreValidInternalException(String.format("Error during core request running for timestamp '%s'", coreValidRequest.getTimestamp()), (Throwable)e);
        }
        catch (ExecutionException e) {
            this.eventsLogger.error("Error during core request running for timestamp {}.", (Object)this.formattedTimestamp);
            throw new CoreValidInternalException(String.format("Error during core request running for timestamp '%s'", coreValidRequest.getTimestamp()), (Throwable)e);
        }
        return new CoreValidResponse(coreValidRequest.getId(), (String)this.resultFileUrls.get(ResultFileExporter.ResultType.MAIN_RESULT), (String)this.resultFileUrls.get(ResultFileExporter.ResultType.REX_RESULT), (String)this.resultFileUrls.get(ResultFileExporter.ResultType.REMEDIAL_ACTIONS_RESULT), this.computationStartInstant, this.computationEndInstant);
    }

    private void preTreatment(CoreValidRequest coreValidRequest) {
        this.clearData();
        this.setUpEventLogging(coreValidRequest);
        this.computationStartInstant = Instant.now();
    }

    private void clearData() {
        if (this.studyPoints != null) {
            this.studyPoints.clear();
        }
        if (this.resultFileUrls != null) {
            this.resultFileUrls.clear();
        }
        this.studyPointCompletableFutures.clear();
        this.studyPointRaoRequests.clear();
        this.studyPointResults.clear();
    }

    private void setUpEventLogging(CoreValidRequest coreValidRequest) {
        MDC.put((String)"gridcapa-task-id", (String)coreValidRequest.getId());
        this.formattedTimestamp = this.timestampFormatter.format(coreValidRequest.getTimestamp());
    }

    private void computeStudyPoints(CoreValidRequest coreValidRequest) throws InterruptedException, ExecutionException {
        this.importStudyPoints(coreValidRequest);
        if (!this.studyPoints.isEmpty()) {
            StudyPointData studyPointData = this.fillStudyPointData(coreValidRequest);
            this.studyPoints.forEach(studyPoint -> this.studyPointRaoRequests.put(studyPoint, this.studyPointService.computeStudyPointShift(studyPoint, studyPointData, coreValidRequest.getTimestamp(), coreValidRequest.getId())));
            this.eventsLogger.info("All studypoints shifts are done for timestamp {}", (Object)this.formattedTimestamp);
            this.runRaoForEachStudyPoint();
            this.fillResultsForEachStudyPoint(studyPointData);
        }
    }

    private void importStudyPoints(CoreValidRequest coreValidRequest) {
        this.studyPoints = this.fileImporter.importStudyPoints(coreValidRequest.getStudyPoints(), coreValidRequest.getTimestamp());
    }

    private StudyPointData fillStudyPointData(CoreValidRequest coreValidRequest) {
        Network network = this.fileImporter.importNetwork(coreValidRequest.getCgm());
        ReferenceProgram referenceProgram = this.fileImporter.importReferenceProgram(coreValidRequest.getRefProg(), coreValidRequest.getTimestamp());
        Map coreNetPositions = NetPositionsHandler.computeCoreReferenceNetPositions((ReferenceProgram)referenceProgram);
        GlskDocument glskDocument = this.fileImporter.importGlskFile(coreValidRequest.getGlsk());
        ZonalData scalableZonalData = glskDocument.getZonalScalable(network, coreValidRequest.getTimestamp().toInstant());
        FbConstraintCreationContext cracCreationContext = this.fileImporter.importCrac(coreValidRequest.getCbcora().getUrl(), coreValidRequest.getTimestamp(), network);
        String jsonCracUrl = this.fileExporter.saveCracInJsonFormat(cracCreationContext.getCrac(), coreValidRequest.getTimestamp());
        RaoParameters raoParameters = this.getRaoParameters();
        String raoParametersUrl = this.fileExporter.saveRaoParametersAndGetUrl(raoParameters);
        return new StudyPointData(network, coreNetPositions, scalableZonalData, cracCreationContext, jsonCracUrl, raoParametersUrl);
    }

    private RaoParameters getRaoParameters() {
        RaoParameters raoParameters = RaoParameters.load();
        SearchTreeRaoParameters searchTreeRaoParameters = (SearchTreeRaoParameters)raoParameters.getExtension(SearchTreeRaoParameters.class);
        this.addParametersToSearchTreeRao(searchTreeRaoParameters);
        raoParameters.addExtension(SearchTreeRaoParameters.class, (Extension)searchTreeRaoParameters);
        return raoParameters;
    }

    private void addParametersToSearchTreeRao(SearchTreeRaoParameters searchTreeRaoParameters) {
        searchTreeRaoParameters.setMaxCurativePstPerTso(this.searchTreeRaoConfiguration.getMaxCurativePstPerTso());
        searchTreeRaoParameters.setMaxCurativeTopoPerTso(this.searchTreeRaoConfiguration.getMaxCurativeTopoPerTso());
        searchTreeRaoParameters.setMaxCurativeRaPerTso(this.searchTreeRaoConfiguration.getMaxCurativeRaPerTso());
    }

    private void runRaoForEachStudyPoint() throws ExecutionException, InterruptedException {
        this.studyPointRaoRequests.forEach((studyPoint, raoRequest) -> {
            CompletableFuture raoResponse = this.studyPointService.computeStudyPointRao(studyPoint, raoRequest);
            this.studyPointCompletableFutures.put(studyPoint, raoResponse);
            ((CompletableFuture)raoResponse.thenApply(raoResponse1 -> {
                LOGGER.info("End of RAO for studypoint {} ...", (Object)studyPoint.getVerticeId());
                return null;
            })).exceptionally(exception -> {
                studyPoint.getStudyPointResult().setStatusToError();
                this.eventsLogger.error("Error during RAO computation for studypoint {}.", (Object)studyPoint.getVerticeId());
                throw new CoreValidRaoException(String.format("Error during RAO computation for studypoint %s .", studyPoint.getVerticeId()));
            });
        });
        CompletableFuture.allOf(this.studyPointCompletableFutures.values().toArray(new CompletableFuture[0])).get();
    }

    private void fillResultsForEachStudyPoint(StudyPointData studyPointData) throws InterruptedException, ExecutionException {
        for (Map.Entry entry : this.studyPointCompletableFutures.entrySet()) {
            StudyPoint studyPoint = (StudyPoint)entry.getKey();
            RaoResponse raoResponse = (RaoResponse)((CompletableFuture)entry.getValue()).get();
            this.studyPointResults.add(this.studyPointService.postTreatRaoResult(studyPoint, studyPointData, raoResponse));
        }
    }

    private void postTreatment(CoreValidRequest coreValidRequest) {
        this.computationEndInstant = Instant.now();
        this.resultFileUrls = this.saveProcessOutputs(this.studyPointResults, coreValidRequest);
        if (coreValidRequest.getLaunchedAutomatically()) {
            this.deleteArtifacts(coreValidRequest);
        }
        this.eventsLogger.info("Process done for timestamp {}.", (Object)this.formattedTimestamp);
    }

    private Map<ResultFileExporter.ResultType, String> saveProcessOutputs(List<StudyPointResult> studyPointResults, CoreValidRequest coreValidRequest) {
        return this.fileExporter.exportStudyPointResult(studyPointResults, coreValidRequest);
    }

    private void deleteArtifacts(CoreValidRequest coreValidRequest) {
        this.deleteCgmBeforeRao(this.artifactsFormatter.format(coreValidRequest.getTimestamp().atZoneSameInstant(ZoneId.of("Europe/Paris"))));
    }

    private void deleteCgmBeforeRao(String prefix) {
        List results = this.minioAdapter.listFiles("artifacts/" + prefix);
        this.minioAdapter.deleteFiles(results);
    }
}

