/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.study_point;

import com.farao_community.farao.commons.CountryEICode;
import com.farao_community.farao.commons.ZonalData;
import com.farao_community.farao.core_valid.api.exception.CoreValidRaoException;
import com.farao_community.farao.gridcapa_core_valid.app.CoreAreasId;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResult;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResultService;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.MinioAdapter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointData;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.farao_community.farao.rao_runner.api.resource.RaoRequest;
import com.farao_community.farao.rao_runner.api.resource.RaoResponse;
import com.farao_community.farao.rao_runner.starter.AsynchronousRaoRunnerClient;
import com.powsybl.action.util.Scalable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StudyPointService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudyPointService.class);
    private static final double DEFAULT_PMAX = 9999.0;
    private static final double DEFAULT_PMIN = -9999.0;
    private final MinioAdapter minioAdapter;
    private final AsynchronousRaoRunnerClient asynchronousRaoRunnerClient;
    private final LimitingBranchResultService limitingBranchResultService;
    private final FileExporter fileExporter;

    public StudyPointService(MinioAdapter minioAdapter, AsynchronousRaoRunnerClient asynchronousRaoRunnerClient, LimitingBranchResultService limitingBranchResultService, FileExporter fileExporter) {
        this.minioAdapter = minioAdapter;
        this.asynchronousRaoRunnerClient = asynchronousRaoRunnerClient;
        this.limitingBranchResultService = limitingBranchResultService;
        this.fileExporter = fileExporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaoRequest computeStudyPointShift(StudyPoint studyPoint, StudyPointData studyPointData) {
        LOGGER.info("Running computation for study point {} ", (Object)studyPoint.getVerticeId());
        Network network = studyPointData.getNetwork();
        ZonalData scalableZonalData = studyPointData.getScalableZonalData();
        Map coreNetPositions = studyPointData.getCoreNetPositions();
        String jsonCracUrl = studyPointData.getJsonCracUrl();
        String raoParametersUrl = studyPointData.getRaoParametersUrl();
        RaoRequest raoRequest = null;
        String initialVariant = network.getVariantManager().getWorkingVariantId();
        String newVariant = initialVariant + "_" + studyPoint.getVerticeId();
        network.getVariantManager().cloneVariant(initialVariant, newVariant);
        network.getVariantManager().setWorkingVariant(newVariant);
        try {
            Map initGenerators = this.setPminPmaxToDefaultValue(network, scalableZonalData);
            NetPositionsHandler.shiftNetPositionToStudyPoint((Network)network, (StudyPoint)studyPoint, (ZonalData)scalableZonalData, (Map)coreNetPositions);
            this.resetInitialPminPmax(network, scalableZonalData, initGenerators);
            String shiftedCgmUrl = this.fileExporter.saveShiftedCgm(network, studyPoint);
            studyPoint.getStudyPointResult().setShiftedCgmUrl(shiftedCgmUrl);
            String raoRequestId = String.format("%s-%s", network.getNameOrId(), studyPoint.getVerticeId());
            String raoDirPath = String.format("%s/artifacts/RAO-%s/", this.minioAdapter.getBasePath(), raoRequestId);
            raoRequest = new RaoRequest(raoRequestId, shiftedCgmUrl, jsonCracUrl, raoParametersUrl, raoDirPath);
        }
        catch (Exception e) {
            LOGGER.error("Error during study point {} computation", (Object)studyPoint.getVerticeId(), (Object)e);
            studyPoint.getStudyPointResult().setStatus(StudyPointResult.Status.ERROR);
        }
        finally {
            network.getVariantManager().setWorkingVariant(initialVariant);
            network.getVariantManager().removeVariant(newVariant);
        }
        return raoRequest;
    }

    public CompletableFuture<RaoResponse> computeStudyPointRao(StudyPoint studyPoint, RaoRequest raoRequest) {
        LOGGER.info("Running RAO for studypoint {} ...", (Object)studyPoint.getVerticeId());
        try {
            return this.asynchronousRaoRunnerClient.runRaoAsynchronously(raoRequest);
        }
        catch (Exception e) {
            LOGGER.error("Error during RAO {}", (Object)studyPoint.getVerticeId(), (Object)e);
            throw new CoreValidRaoException(e.getMessage());
        }
    }

    public StudyPointResult postTreatRaoResult(StudyPoint studyPoint, StudyPointData studyPointData, RaoResponse raoResponse) {
        List limitingBranchResults = this.limitingBranchResultService.importRaoResult(studyPoint, studyPointData.getFbConstraintCreationContext(), raoResponse.getRaoResultFileUrl());
        this.setSuccessResult(studyPoint, raoResponse, limitingBranchResults);
        return studyPoint.getStudyPointResult();
    }

    private Map<String, InitGenerator> setPminPmaxToDefaultValue(Network network, ZonalData<Scalable> scalableZonalData) {
        HashMap<String, InitGenerator> initGenerators = new HashMap<String, InitGenerator>();
        CoreAreasId.getCountriesId().stream().map(zone -> new CountryEICode(Country.valueOf((String)zone)).getCode()).map(arg_0 -> scalableZonalData.getData(arg_0)).filter(Objects::nonNull).map(scalable -> scalable.filterInjections(network).stream().filter(Generator.class::isInstance).map(Generator.class::cast).collect(Collectors.toList())).forEach(generators -> generators.forEach(generator -> {
            if (Double.isNaN(generator.getTargetP())) {
                generator.setTargetP(0.0);
            }
            InitGenerator initGenerator = new InitGenerator();
            initGenerator.setpMin(generator.getMinP());
            initGenerator.setpMax(generator.getMaxP());
            initGenerators.put(generator.getId(), initGenerator);
            generator.setMinP(-9999.0);
            generator.setMaxP(9999.0);
        }));
        LOGGER.info("Pmax and Pmin are set to default values for network {}", (Object)network.getNameOrId());
        return initGenerators;
    }

    private void resetInitialPminPmax(Network network, ZonalData<Scalable> scalableZonalData, Map<String, InitGenerator> initGenerators) {
        CoreAreasId.getCountriesId().forEach(zone -> {
            String zoneEiCode = new CountryEICode(Country.valueOf((String)zone)).getCode();
            Scalable scalable = (Scalable)scalableZonalData.getData(zoneEiCode);
            if (scalable != null) {
                List<Generator> generators = scalable.filterInjections(network).stream().filter(Generator.class::isInstance).map(Generator.class::cast).collect(Collectors.toList());
                generators.forEach(generator -> {
                    generator.setMaxP(Math.max(generator.getTargetP(), ((InitGenerator)initGenerators.get(generator.getId())).getpMax()));
                    generator.setMinP(Math.min(generator.getTargetP(), ((InitGenerator)initGenerators.get(generator.getId())).getpMin()));
                });
            }
        });
        LOGGER.info("Pmax and Pmin are reset to initial values for network {}", (Object)network.getNameOrId());
    }

    private void setSuccessResult(StudyPoint studyPoint, RaoResponse raoResponse, List<LimitingBranchResult> limitingBranchResults) {
        StudyPointResult result = studyPoint.getStudyPointResult();
        result.setListLimitingBranchResult(limitingBranchResults);
        result.setStatus(StudyPointResult.Status.SUCCESS);
        result.setNetworkWithPraUrl(raoResponse.getNetworkWithPraFileUrl());
        result.setRaoResultFileUrl(raoResponse.getRaoResultFileUrl());
        result.setPeriod(String.valueOf(studyPoint.getPeriod()));
    }
}

