/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services;

import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.MinioConfiguration;
import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.http.Method;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MinioAdapter {
    private static final int DEFAULT_DOWNLOAD_LINK_EXPIRY_IN_DAYS = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioAdapter.class);
    public static final String FORMAT_URL = "%s/%s";
    private final MinioClient client;
    private final String bucket;
    private final String basePath;

    public MinioAdapter(MinioConfiguration minioConfiguration, MinioClient minioClient) {
        this.client = minioClient;
        this.bucket = minioConfiguration.getBucket();
        this.basePath = minioConfiguration.getBasePath();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void uploadFile(String filePath, InputStream sourceInputStream) {
        String fullPath = String.format(FORMAT_URL, this.basePath, filePath);
        try {
            this.createBucketIfDoesNotExist(this.bucket);
            this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucket)).object(fullPath)).stream(sourceInputStream, -1L, 50000000L).build());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CoreValidInternalException(String.format("Exception occurred while uploading file: %s, to minio server", filePath));
        }
    }

    public void uploadFile(String filePath, ByteArrayOutputStream baos) {
        byte[] mainByteArray = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(mainByteArray);
        this.uploadFile(filePath, (InputStream)is);
    }

    public String generatePreSignedUrl(String filePath) {
        String fullPath = String.format(FORMAT_URL, this.basePath, filePath);
        try {
            return this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.bucket)).object(fullPath)).expiry(7, TimeUnit.DAYS).method(Method.GET).build());
        }
        catch (Exception e) {
            throw new CoreValidInternalException("Exception in MinIO connection.", (Throwable)e);
        }
    }

    public Iterable<Result<Item>> listArtifacts(String prefix) {
        return this.client.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucket)).prefix(this.basePath + "artifacts/" + prefix).recursive(true).build());
    }

    public void deleteObjects(Iterable<Result<Item>> results) {
        String objectName = "";
        for (Result<Item> result : results) {
            try {
                objectName = ((Item)result.get()).objectName();
                this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucket)).object(((Item)result.get()).objectName())).build());
                LOGGER.info("File {} deleted from Minio", (Object)objectName);
            }
            catch (Exception e) {
                LOGGER.error("Can not delete object {}.", (Object)objectName);
            }
        }
    }

    public boolean exists(String filePath) {
        this.createBucketIfDoesNotExist(this.bucket);
        try {
            StatObjectResponse statObjectResponse = this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucket)).object(this.basePath + filePath)).build());
            if (statObjectResponse == null) {
                LOGGER.warn("File '{}' does not exist in MinIO bucket '{}'", (Object)filePath, (Object)this.bucket);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("File '{}' does not exist in MinIO bucket '{}'", (Object)filePath, (Object)this.bucket);
            return false;
        }
    }

    private void createBucketIfDoesNotExist(String bucket) {
        try {
            if (!this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build())) {
                LOGGER.info("Create Minio bucket '{}' that did not exist already", (Object)bucket);
                this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
            }
        }
        catch (Exception e) {
            throw new CoreValidInternalException(String.format("Cannot create bucket '%s'", bucket), (Throwable)e);
        }
    }
}

