/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services;

import com.farao_community.farao.core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.core_valid.api.resource.CoreValidFileResource;
import com.farao_community.farao.data.crac_creation.creator.api.parameters.CracCreationParameters;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.FbConstraint;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.crac_creator.FbConstraintCracCreator;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.crac_creator.FbConstraintCreationContext;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.importer.FbConstraintImporter;
import com.farao_community.farao.data.glsk.api.GlskDocument;
import com.farao_community.farao.data.glsk.api.io.GlskDocumentImporters;
import com.farao_community.farao.data.refprog.reference_program.ReferenceProgram;
import com.farao_community.farao.data.refprog.refprog_xml_importer.RefProgImporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetworkHandler;
import com.farao_community.farao.gridcapa_core_valid.app.services.UrlValidationService;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointsImporter;
import com.powsybl.iidm.network.Network;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileImporter {
    private final UrlValidationService urlValidationService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileImporter.class);

    public FileImporter(UrlValidationService urlValidationService) {
        this.urlValidationService = urlValidationService;
    }

    public Network importNetwork(CoreValidFileResource cgmFile) {
        InputStream networkStream = this.urlValidationService.openUrlStream(cgmFile.getUrl());
        return NetworkHandler.loadNetwork((String)cgmFile.getFilename(), (InputStream)networkStream);
    }

    public GlskDocument importGlskFile(CoreValidFileResource glskFileResource) {
        GlskDocument glskDocument;
        block8: {
            InputStream glskStream = this.urlValidationService.openUrlStream(glskFileResource.getUrl());
            try {
                LOGGER.info("Import of Glsk file {} ", (Object)glskFileResource.getFilename());
                glskDocument = GlskDocumentImporters.importGlsk((InputStream)glskStream);
                if (glskStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (glskStream != null) {
                        try {
                            glskStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download reference program file from URL '%s'", glskFileResource.getUrl()), (Throwable)e);
                }
            }
            glskStream.close();
        }
        return glskDocument;
    }

    public ReferenceProgram importReferenceProgram(CoreValidFileResource refProgFile, OffsetDateTime timestamp) {
        ReferenceProgram referenceProgram;
        block8: {
            InputStream refProgStream = this.urlValidationService.openUrlStream(refProgFile.getUrl());
            try {
                referenceProgram = RefProgImporter.importRefProg((InputStream)refProgStream, (OffsetDateTime)timestamp);
                if (refProgStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (refProgStream != null) {
                        try {
                            refProgStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download GLSK file from URL '%s'", refProgFile.getUrl()), (Throwable)e);
                }
            }
            refProgStream.close();
        }
        return referenceProgram;
    }

    public List<StudyPoint> importStudyPoints(CoreValidFileResource studyPointsFileResource, OffsetDateTime timestamp) {
        List list;
        block8: {
            InputStream studyPointsStream = this.urlValidationService.openUrlStream(studyPointsFileResource.getUrl());
            try {
                LOGGER.info("Import of study points from {} file for timestamp {} ", (Object)studyPointsFileResource.getFilename(), (Object)timestamp);
                list = StudyPointsImporter.importStudyPoints((InputStream)studyPointsStream, (OffsetDateTime)timestamp);
                if (studyPointsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (studyPointsStream != null) {
                        try {
                            studyPointsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download study points file from URL '%s'", studyPointsFileResource.getUrl()), (Throwable)e);
                }
            }
            studyPointsStream.close();
        }
        return list;
    }

    public FbConstraintCreationContext importCrac(String cbcoraUrl, OffsetDateTime targetProcessDateTime, Network network) {
        FbConstraintCreationContext fbConstraintCreationContext;
        block8: {
            CracCreationParameters cracCreationParameters = new CracCreationParameters();
            InputStream cracInputStream = this.urlValidationService.openUrlStream(cbcoraUrl);
            try {
                FbConstraint nativeCrac = new FbConstraintImporter().importNativeCrac(cracInputStream);
                fbConstraintCreationContext = new FbConstraintCracCreator().createCrac(nativeCrac, network, targetProcessDateTime, cracCreationParameters);
                if (cracInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cracInputStream != null) {
                        try {
                            cracInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download cbcora file from URL '%s'", cbcoraUrl), (Throwable)e);
                }
            }
            cracInputStream.close();
        }
        return fbConstraintCreationContext;
    }
}

