/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.limiting_branch;

import com.farao_community.farao.commons.Unit;
import com.farao_community.farao.data.crac_api.RemedialAction;
import com.farao_community.farao.data.crac_api.State;
import com.farao_community.farao.data.crac_api.cnec.Cnec;
import com.farao_community.farao.data.crac_api.cnec.FlowCnec;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.crac_creator.FbConstraintCreationContext;
import com.farao_community.farao.data.rao_result_api.OptimizationState;
import com.farao_community.farao.data.rao_result_api.RaoResult;
import com.farao_community.farao.data.rao_result_json.RaoResultImporter;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResult;
import com.farao_community.farao.gridcapa_core_valid.app.services.UrlValidationService;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class LimitingBranchResultService {
    private final UrlValidationService urlValidationService;
    private final RaoResultImporter raoResultImporter;

    public LimitingBranchResultService(UrlValidationService urlValidationService) {
        this.urlValidationService = urlValidationService;
        this.raoResultImporter = new RaoResultImporter();
    }

    public List<LimitingBranchResult> importRaoResult(StudyPoint studyPoint, FbConstraintCreationContext cracCreationContext, String raoResultUrl) {
        String verticeId = studyPoint.getVerticeId();
        RaoResult raoResult = this.raoResultImporter.importRaoResult(this.urlValidationService.openUrlStream(raoResultUrl), cracCreationContext.getCrac());
        ArrayList<LimitingBranchResult> listLimitingBranches = new ArrayList<LimitingBranchResult>();
        cracCreationContext.getBranchCnecCreationContexts().forEach(branchCnecCreationContext -> {
            if (branchCnecCreationContext.isImported()) {
                String criticalBranchId = branchCnecCreationContext.getNativeId();
                Map flowCnecsIds = branchCnecCreationContext.getCreatedCnecsIds();
                flowCnecsIds.forEach((instant, flowCnecId) -> {
                    FlowCnec cnec = cracCreationContext.getCrac().getFlowCnec(flowCnecId);
                    LimitingBranchResult branchResult = this.createLimitingBranchResult(verticeId, criticalBranchId, raoResult, cnec);
                    listLimitingBranches.add(branchResult);
                });
            }
        });
        return listLimitingBranches;
    }

    private LimitingBranchResult createLimitingBranchResult(String studyPointId, String criticalBranchId, RaoResult raoResult, FlowCnec cnec) {
        Double ramBefore = raoResult.getMargin(OptimizationState.INITIAL, cnec, Unit.MEGAWATT);
        Double ramAfter = raoResult.getMargin(OptimizationState.afterOptimizing((State)cnec.getState()), cnec, Unit.MEGAWATT);
        Double flowBefore = raoResult.getFlow(OptimizationState.INITIAL, cnec, Unit.MEGAWATT);
        Double flowAfter = raoResult.getFlow(OptimizationState.afterOptimizing((State)cnec.getState()), cnec, Unit.MEGAWATT);
        Set remedialActions = this.getRemedialActions(raoResult, (Cnec)cnec);
        String criticalBranchName = cnec.getName();
        State state = cnec.getState();
        return new LimitingBranchResult(studyPointId, criticalBranchId, ramBefore, ramAfter, flowBefore, flowAfter, remedialActions, criticalBranchName, state);
    }

    private Set<RemedialAction<?>> getRemedialActions(RaoResult raoResult, Cnec<?> cnec) {
        Set networkActions = raoResult.getActivatedNetworkActionsDuringState(cnec.getState());
        Set rangeActions = raoResult.getActivatedRangeActionsDuringState(cnec.getState());
        HashSet remedialActionsActivated = new HashSet();
        remedialActionsActivated.addAll(networkActions);
        remedialActionsActivated.addAll(rangeActions);
        return remedialActionsActivated;
    }
}

