/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services;

import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.resource.CoreValidRequest;
import com.farao_community.farao.data.crac_api.Crac;
import com.farao_community.farao.data.crac_io_api.CracExporters;
import com.farao_community.farao.gridcapa_core_valid.app.services.MinioAdapter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetworkHandler;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.MainResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.RemedialActionsFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.ResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.RexResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.rao_api.json.JsonRaoParameters;
import com.farao_community.farao.rao_api.parameters.RaoParameters;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.MemDataSource;
import com.powsybl.iidm.export.Exporters;
import com.powsybl.iidm.network.Network;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileExporter.class);
    public static final String ARTIFACTS_S = "artifacts/%s";
    private static final String RAO_PARAMETERS_FILE_NAME = "raoParameters.json";
    private final MinioAdapter minioAdapter;
    private final MainResultFileExporter mainResultFileExporter;
    private final RemedialActionsFileExporter remedialActionsFileExporter;
    private final RexResultFileExporter rexResultFileExporter;

    public FileExporter(MinioAdapter minioAdapter, MainResultFileExporter mainResultFileExporter, RemedialActionsFileExporter remedialActionsFileExporter, RexResultFileExporter rexResultFileExporter) {
        this.minioAdapter = minioAdapter;
        this.mainResultFileExporter = mainResultFileExporter;
        this.remedialActionsFileExporter = remedialActionsFileExporter;
        this.rexResultFileExporter = rexResultFileExporter;
    }

    public Map<ResultFileExporter.ResultType, String> exportStudyPointResult(List<StudyPointResult> studyPointResults, CoreValidRequest coreValidRequest) {
        EnumMap<ResultFileExporter.ResultType, String> resultMap = new EnumMap<ResultFileExporter.ResultType, String>(ResultFileExporter.ResultType.class);
        if (coreValidRequest.getLaunchedAutomatically()) {
            resultMap.put(ResultFileExporter.ResultType.MAIN_RESULT, this.mainResultFileExporter.exportStudyPointResult(studyPointResults, coreValidRequest.getTimestamp()));
        }
        resultMap.put(ResultFileExporter.ResultType.REX_RESULT, this.rexResultFileExporter.exportStudyPointResult(studyPointResults, coreValidRequest.getTimestamp()));
        resultMap.put(ResultFileExporter.ResultType.REMEDIAL_ACTIONS_RESULT, this.remedialActionsFileExporter.exportStudyPointResult(studyPointResults, coreValidRequest.getTimestamp()));
        return resultMap;
    }

    public String saveShiftedCgm(Network network, StudyPoint studyPoint) {
        String fileName = network.getNameOrId() + "_" + studyPoint.getVerticeId() + ".xiidm";
        String networkPath = String.format(ARTIFACTS_S, fileName);
        MemDataSource memDataSource = new MemDataSource();
        NetworkHandler.removeAlegroVirtualGeneratorsFromNetwork((Network)network);
        Exporters.export((String)"XIIDM", (Network)network, (Properties)new Properties(), (DataSource)memDataSource);
        try (InputStream is = memDataSource.newInputStream("", "xiidm");){
            LOGGER.info("Uploading shifted cgm to {}", (Object)networkPath);
            this.minioAdapter.uploadFile(networkPath, is);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to save shifted network", (Throwable)e);
        }
        return this.minioAdapter.generatePreSignedUrl(networkPath);
    }

    public String saveRaoParametersAndGetUrl(RaoParameters raoParameters) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonRaoParameters.write((RaoParameters)raoParameters, (OutputStream)baos);
        String raoParametersDestinationPath = String.format(ARTIFACTS_S, RAO_PARAMETERS_FILE_NAME);
        this.minioAdapter.uploadFile(raoParametersDestinationPath, baos);
        return this.minioAdapter.generatePreSignedUrl(raoParametersDestinationPath);
    }

    public String saveCracInJsonFormat(Crac crac, OffsetDateTime timestamp) {
        MemDataSource memDataSource = new MemDataSource();
        String jsonCracFileName = String.format("crac_%s.json", timestamp.toString());
        try (OutputStream os = memDataSource.newOutputStream(jsonCracFileName, false);){
            CracExporters.exportCrac((Crac)crac, (String)"Json", (OutputStream)os);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to save converted CRAC file.", (Throwable)e);
        }
        String cracPath = String.format(ARTIFACTS_S, jsonCracFileName);
        try (InputStream is = memDataSource.newInputStream(jsonCracFileName);){
            this.minioAdapter.uploadFile(cracPath, is);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to upload converted CRAC file.", (Throwable)e);
        }
        return this.minioAdapter.generatePreSignedUrl(cracPath);
    }
}

