/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.configuration;

import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import io.minio.MinioClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MinioConfiguration {
    @Value(value="${minio.access.name}")
    private String accessKey;
    @Value(value="${minio.access.secret}")
    private String accessSecret;
    @Value(value="${minio.url}")
    private String minioUrl;
    @Value(value="${minio.bucket}")
    private String bucket;
    @Value(value="${minio.base-path}")
    private String basePath;

    @Bean
    public MinioClient generateMinioClient() {
        try {
            return MinioClient.builder().endpoint(this.minioUrl).credentials(this.accessKey, this.accessSecret).build();
        }
        catch (Exception e) {
            throw new CoreValidInternalException("Exception in MinIO client", (Throwable)e);
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

