/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.configuration;

import com.farao_community.farao.gridcapa_core_valid.app.CoreValidListener;
import java.util.Optional;
import org.springframework.amqp.core.AsyncAmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AmqpMessagesConfiguration {
    @Value(value="${core-valid-runner.bindings.response.destination}")
    private String responseDestination;
    @Value(value="${core-valid-runner.bindings.response.expiration}")
    private String responseExpiration;
    @Value(value="${core-valid-runner.bindings.request.destination}")
    private String requestDestination;
    @Value(value="${core-valid-runner.bindings.request.routing-key}")
    private String requestRoutingKey;
    @Value(value="${core-valid-runner.async-time-out}")
    private long asyncTimeOut;

    @Bean
    AsyncAmqpTemplate asyncTemplate(RabbitTemplate rabbitTemplate) {
        AsyncRabbitTemplate asyncTemplate = new AsyncRabbitTemplate(rabbitTemplate);
        asyncTemplate.setReceiveTimeout(this.asyncTimeOut);
        return asyncTemplate;
    }

    @Bean
    public Queue coreValidRequestQueue() {
        return new Queue(this.requestDestination);
    }

    @Bean
    public TopicExchange coreValidTopicExchange() {
        return new TopicExchange(this.requestDestination);
    }

    @Bean
    public Binding coreValidRequestBinding() {
        return BindingBuilder.bind((Queue)this.coreValidRequestQueue()).to(this.coreValidTopicExchange()).with(Optional.ofNullable(this.requestRoutingKey).orElse("#"));
    }

    @Bean
    public MessageListenerContainer messageListenerContainer(ConnectionFactory connectionFactory, Queue coreValidRequestQueue, CoreValidListener listener) {
        SimpleMessageListenerContainer simpleMessageListenerContainer = new SimpleMessageListenerContainer();
        simpleMessageListenerContainer.setConnectionFactory(connectionFactory);
        simpleMessageListenerContainer.setQueues(new Queue[]{coreValidRequestQueue});
        simpleMessageListenerContainer.setMessageListener((MessageListener)listener);
        return simpleMessageListenerContainer;
    }

    @Bean
    public FanoutExchange coreValidResponseExchange() {
        return new FanoutExchange(this.responseDestination);
    }

    public String coreValidResponseExpiration() {
        return this.responseExpiration;
    }
}

