/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.farao_community.farao.commons.ZonalData;
import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.exception.CoreValidRaoException;
import com.farao_community.farao.core_valid.api.resource.CoreValidRequest;
import com.farao_community.farao.core_valid.api.resource.CoreValidResponse;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.crac_creator.FbConstraintCreationContext;
import com.farao_community.farao.data.glsk.api.GlskDocument;
import com.farao_community.farao.data.refprog.reference_program.ReferenceProgram;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.SearchTreeRaoConfiguration;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileImporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.services.results_export.ResultFileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointData;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.farao_community.farao.rao_api.parameters.RaoParameters;
import com.farao_community.farao.rao_runner.api.resource.RaoRequest;
import com.farao_community.farao.rao_runner.api.resource.RaoResponse;
import com.farao_community.farao.search_tree_rao.castor.parameters.SearchTreeRaoParameters;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Network;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CoreValidHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreValidHandler.class);
    private final StudyPointService studyPointService;
    private final FileImporter fileImporter;
    private final FileExporter fileExporter;
    private final SearchTreeRaoConfiguration searchTreeRaoConfiguration;

    public CoreValidHandler(StudyPointService studyPointService, FileImporter fileImporter, FileExporter fileExporter, SearchTreeRaoConfiguration searchTreeRaoConfiguration) {
        this.studyPointService = studyPointService;
        this.fileImporter = fileImporter;
        this.fileExporter = fileExporter;
        this.searchTreeRaoConfiguration = searchTreeRaoConfiguration;
    }

    public CoreValidResponse handleCoreValidRequest(CoreValidRequest coreValidRequest) {
        try {
            HashMap studyPointCompletableFutures = new HashMap();
            Instant computationStartInstant = Instant.now();
            List studyPoints = this.fileImporter.importStudyPoints(coreValidRequest.getStudyPoints(), coreValidRequest.getTimestamp());
            HashMap<StudyPoint, RaoRequest> studyPointRaoRequests = new HashMap<StudyPoint, RaoRequest>();
            ArrayList<StudyPointResult> studyPointResults = new ArrayList<StudyPointResult>();
            if (!studyPoints.isEmpty()) {
                StudyPointData studyPointData = this.fillStudyPointData(coreValidRequest);
                studyPoints.forEach(studyPoint -> studyPointRaoRequests.put((StudyPoint)studyPoint, this.studyPointService.computeStudyPointShift(studyPoint, studyPointData)));
                studyPointRaoRequests.forEach((studyPoint, raoRequest) -> {
                    CompletableFuture raoResponse = this.studyPointService.computeStudyPointRao(studyPoint, raoRequest);
                    studyPointCompletableFutures.put(studyPoint, raoResponse);
                    ((CompletableFuture)raoResponse.thenApply(raoResponse1 -> {
                        LOGGER.info("End of RAO computation for studypoint {} .", (Object)studyPoint.getVerticeId());
                        return null;
                    })).exceptionally(exception -> {
                        studyPoint.getStudyPointResult().setStatusToError();
                        throw new CoreValidRaoException(String.format("Error during RAO computation for studypoint %s .", studyPoint.getVerticeId()));
                    });
                });
                CompletableFuture.allOf(studyPointCompletableFutures.values().toArray(new CompletableFuture[0])).get();
                for (Map.Entry entry : studyPointCompletableFutures.entrySet()) {
                    StudyPoint studyPoint2 = (StudyPoint)entry.getKey();
                    RaoResponse raoResponse = (RaoResponse)((CompletableFuture)entry.getValue()).get();
                    studyPointResults.add(this.studyPointService.postTreatRaoResult(studyPoint2, studyPointData, raoResponse));
                }
            }
            Instant computationEndInstant = Instant.now();
            Map resultFileUrls = this.saveProcessOutputs(studyPointResults, coreValidRequest);
            return new CoreValidResponse(coreValidRequest.getId(), (String)resultFileUrls.get(ResultFileExporter.ResultType.MAIN_RESULT), (String)resultFileUrls.get(ResultFileExporter.ResultType.REX_RESULT), (String)resultFileUrls.get(ResultFileExporter.ResultType.REMEDIAL_ACTIONS_RESULT), computationStartInstant, computationEndInstant);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoreValidInternalException(String.format("Error during core request running for timestamp '%s'", coreValidRequest.getTimestamp()), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CoreValidInternalException(String.format("Error during core request running for timestamp '%s'", coreValidRequest.getTimestamp()), (Throwable)e);
        }
    }

    private StudyPointData fillStudyPointData(CoreValidRequest coreValidRequest) {
        Network network = this.fileImporter.importNetwork(coreValidRequest.getCgm().getFilename(), coreValidRequest.getCgm().getUrl());
        ReferenceProgram referenceProgram = this.fileImporter.importReferenceProgram(coreValidRequest.getRefProg(), coreValidRequest.getTimestamp());
        Map coreNetPositions = NetPositionsHandler.computeCoreReferenceNetPositions((ReferenceProgram)referenceProgram);
        GlskDocument glskDocument = this.fileImporter.importGlskFile(coreValidRequest.getGlsk());
        ZonalData scalableZonalData = glskDocument.getZonalScalable(network, coreValidRequest.getTimestamp().toInstant());
        FbConstraintCreationContext cracCreationContext = this.fileImporter.importCrac(coreValidRequest.getCbcora().getUrl(), coreValidRequest.getTimestamp(), network);
        String jsonCracUrl = this.fileExporter.saveCracInJsonFormat(cracCreationContext.getCrac(), coreValidRequest.getTimestamp());
        RaoParameters raoParameters = this.getRaoParametersConfig();
        String raoParametersUrl = this.fileExporter.saveRaoParametersAndGetUrl(raoParameters);
        return new StudyPointData(network, coreNetPositions, scalableZonalData, cracCreationContext, jsonCracUrl, raoParametersUrl);
    }

    private RaoParameters getRaoParametersConfig() {
        RaoParameters raoParameters = RaoParameters.load();
        SearchTreeRaoParameters searchTreeRaoParameters = (SearchTreeRaoParameters)raoParameters.getExtension(SearchTreeRaoParameters.class);
        searchTreeRaoParameters.setMaxCurativePstPerTso(this.searchTreeRaoConfiguration.getMaxCurativePstPerTso());
        searchTreeRaoParameters.setMaxCurativeTopoPerTso(this.searchTreeRaoConfiguration.getMaxCurativeTopoPerTso());
        searchTreeRaoParameters.setMaxCurativeRaPerTso(this.searchTreeRaoConfiguration.getMaxCurativeRaPerTso());
        raoParameters.addExtension(SearchTreeRaoParameters.class, (Extension)searchTreeRaoParameters);
        return raoParameters;
    }

    private Map<ResultFileExporter.ResultType, String> saveProcessOutputs(List<StudyPointResult> studyPointResults, CoreValidRequest coreValidRequest) {
        return this.fileExporter.exportStudyPointResult(studyPointResults, coreValidRequest);
    }
}

