/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.study_point;

import com.farao_community.farao.commons.CountryEICode;
import com.farao_community.farao.commons.ZonalData;
import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.exception.CoreValidRaoException;
import com.farao_community.farao.gridcapa_core_valid.app.CoreAreasId;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.SearchTreeRaoConfiguration;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResult;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResultService;
import com.farao_community.farao.gridcapa_core_valid.app.services.MinioAdapter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetworkHandler;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointData;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.farao_community.farao.rao_api.json.JsonRaoParameters;
import com.farao_community.farao.rao_api.parameters.RaoParameters;
import com.farao_community.farao.rao_runner.api.resource.RaoRequest;
import com.farao_community.farao.rao_runner.api.resource.RaoResponse;
import com.farao_community.farao.rao_runner.starter.RaoRunnerClient;
import com.farao_community.farao.search_tree_rao.SearchTreeRaoParameters;
import com.powsybl.action.util.Scalable;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.MemDataSource;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.export.Exporters;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StudyPointService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudyPointService.class);
    private static final String RAO_PARAMETERS_FILE_NAME = "raoParameters.json";
    private static final double DEFAULT_PMAX = 9999.0;
    private static final double DEFAULT_PMIN = -9999.0;
    public static final String ARTIFACTS_S = "artifacts/%s";
    private final MinioAdapter minioAdapter;
    private final RaoRunnerClient raoRunnerClient;
    private final LimitingBranchResultService limitingBranchResultService;
    private final SearchTreeRaoConfiguration searchTreeRaoConfiguration;

    public StudyPointService(MinioAdapter minioAdapter, RaoRunnerClient raoRunnerClient, LimitingBranchResultService limitingBranchResultService, SearchTreeRaoConfiguration searchTreeRaoConfiguration) {
        this.minioAdapter = minioAdapter;
        this.raoRunnerClient = raoRunnerClient;
        this.limitingBranchResultService = limitingBranchResultService;
        this.searchTreeRaoConfiguration = searchTreeRaoConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StudyPointResult computeStudyPoint(StudyPoint studyPoint, StudyPointData studyPointData) {
        LOGGER.info("Running computation for study point {} ", (Object)studyPoint.getVerticeId());
        Network network = studyPointData.getNetwork();
        ZonalData scalableZonalData = studyPointData.getScalableZonalData();
        Map coreNetPositions = studyPointData.getCoreNetPositions();
        String jsonCracUrl = studyPointData.getJsonCracUrl();
        StudyPointResult result = new StudyPointResult(studyPoint.getVerticeId());
        String initialVariant = network.getVariantManager().getWorkingVariantId();
        String newVariant = initialVariant + "_" + studyPoint.getVerticeId();
        network.getVariantManager().cloneVariant(initialVariant, newVariant);
        network.getVariantManager().setWorkingVariant(newVariant);
        try {
            Map initGenerators = this.setPminPmaxToDefaultValue(network, scalableZonalData);
            NetPositionsHandler.shiftNetPositionToStudyPoint((Network)network, (StudyPoint)studyPoint, (ZonalData)scalableZonalData, (Map)coreNetPositions);
            this.resetInitialPminPmax(network, scalableZonalData, initGenerators);
            String shiftedCgmUrl = this.saveShiftedCgm(network, studyPoint);
            result.setShiftedCgmUrl(shiftedCgmUrl);
            String raoRequestId = String.format("%s-%s", network.getNameOrId(), studyPoint.getVerticeId());
            LOGGER.info("Running RAO for studypoint {} ...", (Object)studyPoint.getVerticeId());
            RaoResponse raoResponse = this.startRao(raoRequestId, shiftedCgmUrl, jsonCracUrl, this.saveRaoParametersAndGetUrl());
            LOGGER.info("End of RAO computation for studypoint {} .", (Object)studyPoint.getVerticeId());
            List limitingBranchResults = this.limitingBranchResultService.importRaoResult(studyPoint, studyPointData.getFbConstraintCreationContext(), raoResponse.getRaoResultFileUrl());
            this.setSuccessResult(studyPoint, result, raoResponse, limitingBranchResults);
        }
        catch (CoreValidRaoException e) {
            LOGGER.error("Error during RAO {}", (Object)studyPoint.getVerticeId(), (Object)e);
            result.setStatus(StudyPointResult.Status.ERROR);
        }
        catch (Exception e) {
            LOGGER.error("Error during study point {} computation", (Object)studyPoint.getVerticeId(), (Object)e);
            result.setStatus(StudyPointResult.Status.ERROR);
        }
        finally {
            network.getVariantManager().setWorkingVariant(initialVariant);
            network.getVariantManager().removeVariant(newVariant);
        }
        return result;
    }

    private RaoResponse startRao(String raoRequestId, String networkUrl, String cracUrl, String raoParametersUrl) throws CoreValidRaoException {
        try {
            RaoRequest raoRequest = new RaoRequest(raoRequestId, networkUrl, cracUrl, raoParametersUrl);
            return this.raoRunnerClient.runRao(raoRequest);
        }
        catch (Exception e) {
            throw new CoreValidRaoException(String.format("Error during RAO for request %s", raoRequestId), (Throwable)e);
        }
    }

    private String saveShiftedCgm(Network network, StudyPoint studyPoint) {
        String fileName = network.getNameOrId() + "_" + studyPoint.getVerticeId() + ".xiidm";
        String networkPath = String.format(ARTIFACTS_S, fileName);
        MemDataSource memDataSource = new MemDataSource();
        NetworkHandler.removeAlegroVirtualGeneratorsFromNetwork((Network)network);
        Exporters.export((String)"XIIDM", (Network)network, (Properties)new Properties(), (DataSource)memDataSource);
        try (InputStream is = memDataSource.newInputStream("", "xiidm");){
            LOGGER.info("Uploading shifted cgm to {}", (Object)networkPath);
            this.minioAdapter.uploadFile(networkPath, is);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to save shifted network", (Throwable)e);
        }
        return this.minioAdapter.generatePreSignedUrl(networkPath);
    }

    private Map<String, InitGenerator> setPminPmaxToDefaultValue(Network network, ZonalData<Scalable> scalableZonalData) {
        HashMap<String, InitGenerator> initGenerators = new HashMap<String, InitGenerator>();
        CoreAreasId.getCountriesId().stream().map(zone -> new CountryEICode(Country.valueOf((String)zone)).getCode()).map(arg_0 -> scalableZonalData.getData(arg_0)).filter(Objects::nonNull).map(scalable -> scalable.filterInjections(network).stream().filter(Generator.class::isInstance).map(Generator.class::cast).collect(Collectors.toList())).forEach(generators -> generators.forEach(generator -> {
            if (Double.isNaN(generator.getTargetP())) {
                generator.setTargetP(0.0);
            }
            InitGenerator initGenerator = new InitGenerator();
            initGenerator.setpMin(generator.getMinP());
            initGenerator.setpMax(generator.getMaxP());
            initGenerators.put(generator.getId(), initGenerator);
            generator.setMinP(-9999.0);
            generator.setMaxP(9999.0);
        }));
        LOGGER.info("Pmax and Pmin are set to default values for network {}", (Object)network.getNameOrId());
        return initGenerators;
    }

    private void resetInitialPminPmax(Network network, ZonalData<Scalable> scalableZonalData, Map<String, InitGenerator> initGenerators) {
        CoreAreasId.getCountriesId().forEach(zone -> {
            String zoneEiCode = new CountryEICode(Country.valueOf((String)zone)).getCode();
            Scalable scalable = (Scalable)scalableZonalData.getData(zoneEiCode);
            if (scalable != null) {
                List<Generator> generators = scalable.filterInjections(network).stream().filter(Generator.class::isInstance).map(Generator.class::cast).collect(Collectors.toList());
                generators.forEach(generator -> {
                    generator.setMaxP(Math.max(generator.getTargetP(), ((InitGenerator)initGenerators.get(generator.getId())).getpMax()));
                    generator.setMinP(Math.min(generator.getTargetP(), ((InitGenerator)initGenerators.get(generator.getId())).getpMin()));
                });
            }
        });
        LOGGER.info("Pmax and Pmin are reset to initial values for network {}", (Object)network.getNameOrId());
    }

    private String saveRaoParametersAndGetUrl() {
        RaoParameters raoParameters = RaoParameters.load();
        SearchTreeRaoParameters searchTreeRaoParameters = (SearchTreeRaoParameters)raoParameters.getExtension(SearchTreeRaoParameters.class);
        searchTreeRaoParameters.setMaxCurativePstPerTso(this.searchTreeRaoConfiguration.getMaxCurativePstPerTso());
        searchTreeRaoParameters.setMaxCurativeTopoPerTso(this.searchTreeRaoConfiguration.getMaxCurativeTopoPerTso());
        searchTreeRaoParameters.setMaxCurativeRaPerTso(this.searchTreeRaoConfiguration.getMaxCurativeRaPerTso());
        raoParameters.addExtension(SearchTreeRaoParameters.class, (Extension)searchTreeRaoParameters);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonRaoParameters.write((RaoParameters)raoParameters, (OutputStream)baos);
        String raoParametersDestinationPath = String.format(ARTIFACTS_S, RAO_PARAMETERS_FILE_NAME);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this.minioAdapter.uploadFile(raoParametersDestinationPath, (InputStream)bais);
        return this.minioAdapter.generatePreSignedUrl(raoParametersDestinationPath);
    }

    private void setSuccessResult(StudyPoint studyPoint, StudyPointResult result, RaoResponse raoResponse, List<LimitingBranchResult> limitingBranchResults) {
        result.setListLimitingBranchResult(limitingBranchResults);
        result.setStatus(StudyPointResult.Status.SUCCESS);
        result.setNetworkWithPraUrl(raoResponse.getNetworkWithPraFileUrl());
        result.setRaoResultFileUrl(raoResponse.getRaoResultFileUrl());
        result.setPeriod(String.valueOf(studyPoint.getPeriod()));
    }
}

