/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services;

import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.resource.CoreValidFileResource;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.MinioConfiguration;
import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.http.Method;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MinioAdapter {
    private static final int DEFAULT_DOWNLOAD_LINK_EXPIRY_IN_DAYS = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioAdapter.class);
    private final MinioClient client;
    private final String bucket;
    private final String basePath;

    public MinioAdapter(MinioConfiguration minioConfiguration, MinioClient minioClient) {
        this.client = minioClient;
        this.bucket = minioConfiguration.getBucket();
        this.basePath = minioConfiguration.getBasePath();
    }

    public void uploadFile(String filePath, InputStream sourceInputStream) {
        String fullPath = String.format("%s/%s", this.basePath, filePath);
        try {
            this.createBucketIfDoesNotExist(this.bucket);
            this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucket)).object(fullPath)).stream(sourceInputStream, -1L, 50000000L).build());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CoreValidInternalException(String.format("Exception occurred while uploading file: %s, to minio server", filePath));
        }
    }

    public String generatePreSignedUrl(String filePath) {
        String fullPath = String.format("%s/%s", this.basePath, filePath);
        try {
            return this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.bucket)).object(fullPath)).expiry(7, TimeUnit.DAYS).method(Method.GET).build());
        }
        catch (Exception e) {
            throw new CoreValidInternalException("Exception in MinIO connection.", (Throwable)e);
        }
    }

    public CoreValidFileResource generateFileResource(String filePath) {
        try {
            String fullFilePath = String.format("%s/%s", this.basePath, filePath);
            String filename = FilenameUtils.getName((String)filePath);
            LOGGER.info("Generates pre-signed URL for file '{}' in Minio bucket '{}'", (Object)fullFilePath, (Object)this.bucket);
            String url = this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.bucket)).object(fullFilePath)).expiry(7, TimeUnit.DAYS).method(Method.GET).build());
            return new CoreValidFileResource(filename, url);
        }
        catch (Exception e) {
            throw new CoreValidInternalException("Exception in MinIO connection.", (Throwable)e);
        }
    }

    private void createBucketIfDoesNotExist(String bucket) {
        try {
            if (!this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build())) {
                LOGGER.info("Create Minio bucket '{}' that did not exist already", (Object)bucket);
                this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
            }
        }
        catch (Exception e) {
            throw new CoreValidInternalException(String.format("Cannot create bucket '%s'", bucket), (Throwable)e);
        }
    }
}

