/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.services;

import com.farao_community.farao.core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResult;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.MinioAdapter;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileExporter.class);
    private static final String SAMPLE_CSV_FILE = "outputs/%s-ValidationCORE-v0.csv";
    private final MinioAdapter minioAdapter;

    public FileExporter(MinioAdapter minioAdapter) {
        this.minioAdapter = minioAdapter;
    }

    public String exportStudyPointResult(List<StudyPointResult> studyPointResults, OffsetDateTime timestamp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)new OutputStreamWriter(baos), CSVFormat.EXCEL.withDelimiter(';').withHeader(new String[]{"Period", "Vertice ID", "Branch ID", "Branch Status", "RAM before", "RAM after"}));
            for (StudyPointResult studyPointResult : studyPointResults) {
                this.addStudyPointResultToOutputFile(studyPointResult, csvPrinter);
            }
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (IOException e) {
            throw new CoreValidInvalidDataException("Error during export of studypoint results on Minio", (Throwable)e);
        }
        byte[] barray = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(barray);
        String filePath = String.format(SAMPLE_CSV_FILE, timestamp.atZoneSameInstant(ZoneId.of("Europe/Paris")).format(DateTimeFormatter.ofPattern("yyyyMMdd-HH")));
        this.minioAdapter.uploadFile(filePath, (InputStream)is);
        LOGGER.info("Result file was successfully uploaded on minIO");
        return this.minioAdapter.generatePreSignedUrl(filePath);
    }

    private void addStudyPointResultToOutputFile(StudyPointResult studyPointResult, CSVPrinter csvPrinter) throws IOException {
        for (LimitingBranchResult limitingBranchResult : studyPointResult.getListLimitingBranchResult()) {
            this.addLimitingBranchResultToOutputFile(limitingBranchResult, studyPointResult, csvPrinter);
        }
    }

    private void addLimitingBranchResultToOutputFile(LimitingBranchResult limitingBranchResult, StudyPointResult studyPointResult, CSVPrinter csvPrinter) throws IOException {
        String branchStatus;
        String period = studyPointResult.getPeriod();
        String verticeId = studyPointResult.getId();
        String branchId = limitingBranchResult.getCriticalBranchId();
        switch (1.$SwitchMap$com$farao_community$farao$data$crac_api$Instant[limitingBranchResult.getState().getInstant().ordinal()]) {
            case 1: {
                branchStatus = "P";
                break;
            }
            case 2: {
                branchStatus = "O";
                break;
            }
            case 3: {
                branchStatus = "C";
                break;
            }
            default: {
                throw new CoreValidInvalidDataException(String.format("Invalid value in CBCORA file, for cnec {}", branchId));
            }
        }
        String ramBefore = String.valueOf(Math.round(limitingBranchResult.getRamBefore()));
        String ramAfter = String.valueOf(Math.round(limitingBranchResult.getRamAfter()));
        csvPrinter.printRecord(new Object[]{period, verticeId, branchId, branchStatus, ramBefore, ramAfter});
    }
}

