/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.farao_community.farao.core_valid.api.JsonApiConverter;
import com.farao_community.farao.core_valid.api.exception.AbstractCoreValidException;
import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.core_valid.api.resource.CoreValidRequest;
import com.farao_community.farao.core_valid.api.resource.CoreValidResponse;
import com.farao_community.farao.gridcapa.task_manager.api.TaskStatus;
import com.farao_community.farao.gridcapa.task_manager.api.TaskStatusUpdate;
import com.farao_community.farao.gridcapa_core_valid.app.CoreValidHandler;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.AmqpMessagesConfiguration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.stereotype.Component;

@Component
public class CoreValidListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreValidListener.class);
    private static final String APPLICATION_ID = "core-valid-runner";
    private static final String CONTENT_ENCODING = "UTF-8";
    private static final String CONTENT_TYPE = "application/vnd.api+json";
    private static final int PRIORITY = 1;
    private static final String TASK_STATUS_UPDATE = "task-status-update";
    private final JsonApiConverter jsonApiConverter;
    private final AmqpTemplate amqpTemplate;
    private final CoreValidHandler coreValidHandler;
    private final AmqpMessagesConfiguration amqpMessagesConfiguration;
    private final StreamBridge streamBridge;

    public CoreValidListener(CoreValidHandler coreValidHandler, AmqpTemplate amqpTemplate, AmqpMessagesConfiguration amqpMessagesConfiguration, StreamBridge streamBridge) {
        this.streamBridge = streamBridge;
        this.jsonApiConverter = new JsonApiConverter();
        this.coreValidHandler = coreValidHandler;
        this.amqpTemplate = amqpTemplate;
        this.amqpMessagesConfiguration = amqpMessagesConfiguration;
    }

    public void onMessage(Message message) {
        String replyTo = message.getMessageProperties().getReplyTo();
        String correlationId = message.getMessageProperties().getCorrelationId();
        try {
            CoreValidRequest coreValidRequest = (CoreValidRequest)this.jsonApiConverter.fromJsonMessage(message.getBody(), CoreValidRequest.class);
            this.runCoreValidRequest(coreValidRequest, replyTo, correlationId);
        }
        catch (AbstractCoreValidException e) {
            LOGGER.error("Core valid exception occured", (Throwable)e);
            this.sendRequestErrorResponse(e, replyTo, correlationId);
        }
        catch (RuntimeException e) {
            CoreValidInvalidDataException wrappingException = new CoreValidInvalidDataException("Unhandled exception: " + e.getMessage(), (Throwable)e);
            this.sendRequestErrorResponse((AbstractCoreValidException)wrappingException, replyTo, correlationId);
        }
    }

    private void sendRequestErrorResponse(AbstractCoreValidException e, String replyTo, String correlationId) {
        if (replyTo != null) {
            this.amqpTemplate.send(replyTo, this.createErrorResponse(e, correlationId));
        } else {
            this.amqpTemplate.send(this.amqpMessagesConfiguration.coreValidResponseExchange().getName(), "", this.createErrorResponse(e, correlationId));
        }
    }

    private void runCoreValidRequest(CoreValidRequest coreValidRequest, String replyTo, String correlationId) {
        try {
            LOGGER.info("Core valid request received: {}", (Object)coreValidRequest);
            this.streamBridge.send(TASK_STATUS_UPDATE, (Object)new TaskStatusUpdate(UUID.fromString(coreValidRequest.getId()), TaskStatus.RUNNING));
            CoreValidResponse coreValidResponse = this.coreValidHandler.handleCoreValidRequest(coreValidRequest);
            this.sendCoreValidResponse(coreValidResponse, replyTo, correlationId);
        }
        catch (AbstractCoreValidException e) {
            LOGGER.error("Core valid exception occured", (Throwable)e);
            this.sendErrorResponse(coreValidRequest.getId(), e, replyTo, correlationId);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unknown exception occured", (Throwable)e);
            CoreValidInternalException wrappingException = new CoreValidInternalException("Unknown exception", (Throwable)e);
            this.sendErrorResponse(coreValidRequest.getId(), (AbstractCoreValidException)wrappingException, replyTo, correlationId);
        }
    }

    private void sendErrorResponse(String requestId, AbstractCoreValidException e, String replyTo, String correlationId) {
        this.streamBridge.send(TASK_STATUS_UPDATE, (Object)new TaskStatusUpdate(UUID.fromString(requestId), TaskStatus.ERROR));
        if (replyTo != null) {
            this.amqpTemplate.send(replyTo, this.createErrorResponse(e, correlationId));
        } else {
            this.amqpTemplate.send(this.amqpMessagesConfiguration.coreValidResponseExchange().getName(), "", this.createErrorResponse(e, correlationId));
        }
    }

    private void sendCoreValidResponse(CoreValidResponse coreValidResponse, String replyTo, String correlationId) {
        this.streamBridge.send(TASK_STATUS_UPDATE, (Object)new TaskStatusUpdate(UUID.fromString(coreValidResponse.getId()), TaskStatus.SUCCESS));
        if (replyTo != null) {
            this.amqpTemplate.send(replyTo, this.createMessageResponse(coreValidResponse, correlationId));
        } else {
            this.amqpTemplate.send(this.amqpMessagesConfiguration.coreValidResponseExchange().getName(), "", this.createMessageResponse(coreValidResponse, correlationId));
        }
        LOGGER.info("Core valid response sent: {}", (Object)coreValidResponse);
    }

    private Message createMessageResponse(CoreValidResponse coreValidResponse, String correlationId) {
        return MessageBuilder.withBody((byte[])this.jsonApiConverter.toJsonMessage((Object)coreValidResponse)).andProperties(this.buildMessageResponseProperties(correlationId)).build();
    }

    private Message createErrorResponse(AbstractCoreValidException exception, String correlationId) {
        return MessageBuilder.withBody((byte[])this.jsonApiConverter.toJsonMessage(exception)).andProperties(this.buildMessageResponseProperties(correlationId)).build();
    }

    private MessageProperties buildMessageResponseProperties(String correlationId) {
        return (MessageProperties)MessagePropertiesBuilder.newInstance().setAppId(APPLICATION_ID).setContentEncoding(CONTENT_ENCODING).setContentType(CONTENT_TYPE).setCorrelationId(correlationId).setDeliveryMode(MessageDeliveryMode.NON_PERSISTENT).setExpiration(this.amqpMessagesConfiguration.coreValidResponseExpiration()).setPriority(Integer.valueOf(1)).build();
    }
}

