/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.farao_community.farao.commons.ZonalData;
import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.resource.CoreValidRequest;
import com.farao_community.farao.core_valid.api.resource.CoreValidResponse;
import com.farao_community.farao.data.crac_api.Crac;
import com.farao_community.farao.data.crac_creation.creator.fb_constraint.crac_creator.FbConstraintCreationContext;
import com.farao_community.farao.data.crac_io_api.CracExporters;
import com.farao_community.farao.data.glsk.api.GlskDocument;
import com.farao_community.farao.data.refprog.reference_program.ReferenceProgram;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.SearchTreeRaoConfiguration;
import com.farao_community.farao.gridcapa_core_valid.app.limiting_branch.LimitingBranchResultService;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileExporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.FileImporter;
import com.farao_community.farao.gridcapa_core_valid.app.services.MinioAdapter;
import com.farao_community.farao.gridcapa_core_valid.app.services.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointData;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.farao_community.farao.rao_runner.starter.RaoRunnerClient;
import com.powsybl.commons.datasource.MemDataSource;
import com.powsybl.iidm.network.Network;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class CoreValidHandler {
    private final MinioAdapter minioAdapter;
    private final RaoRunnerClient raoRunnerClient;
    private final FileImporter fileImporter;
    private final FileExporter fileExporter;
    private final LimitingBranchResultService limitingBranchResult;
    public static final String ARTIFACTS_S = "artifacts/%s";
    private final SearchTreeRaoConfiguration searchTreeRaoConfiguration;

    public CoreValidHandler(MinioAdapter minioAdapter, RaoRunnerClient raoRunnerClient, FileImporter fileImporter, FileExporter fileExporter, LimitingBranchResultService limitingBranchResult, SearchTreeRaoConfiguration searchTreeRaoConfiguration) {
        this.minioAdapter = minioAdapter;
        this.raoRunnerClient = raoRunnerClient;
        this.fileImporter = fileImporter;
        this.fileExporter = fileExporter;
        this.limitingBranchResult = limitingBranchResult;
        this.searchTreeRaoConfiguration = searchTreeRaoConfiguration;
    }

    public CoreValidResponse handleCoreValidRequest(CoreValidRequest coreValidRequest) {
        try {
            Instant computationStartInstant = Instant.now();
            List studyPoints = this.fileImporter.importStudyPoints(coreValidRequest.getStudyPoints(), coreValidRequest.getTimestamp());
            ArrayList studyPointResults = new ArrayList();
            if (!studyPoints.isEmpty()) {
                StudyPointService studyPointService = new StudyPointService(this.minioAdapter, this.raoRunnerClient, this.limitingBranchResult, this.searchTreeRaoConfiguration);
                Network network = this.fileImporter.importNetwork(coreValidRequest.getCgm().getFilename(), coreValidRequest.getCgm().getUrl());
                ReferenceProgram referenceProgram = this.fileImporter.importReferenceProgram(coreValidRequest.getRefProg(), coreValidRequest.getTimestamp());
                Map coreNetPositions = NetPositionsHandler.computeCoreReferenceNetPositions((ReferenceProgram)referenceProgram);
                GlskDocument glskDocument = this.fileImporter.importGlskFile(coreValidRequest.getGlsk());
                ZonalData scalableZonalData = glskDocument.getZonalScalable(network, coreValidRequest.getTimestamp().toInstant());
                FbConstraintCreationContext cracCreationContext = this.fileImporter.importCrac(coreValidRequest.getCbcora().getUrl(), coreValidRequest.getTimestamp(), network);
                String jsonCracUrl = this.saveCracInJsonFormat(cracCreationContext.getCrac(), coreValidRequest.getTimestamp());
                StudyPointData studyPointData = new StudyPointData(network, coreNetPositions, scalableZonalData, cracCreationContext, jsonCracUrl);
                studyPoints.forEach(studyPoint -> studyPointResults.add(studyPointService.computeStudyPoint(studyPoint, studyPointData)));
            }
            String resultFileUrl = this.saveProcessOutputs(studyPointResults, coreValidRequest.getTimestamp());
            Instant computationEndInstant = Instant.now();
            return new CoreValidResponse(coreValidRequest.getId(), resultFileUrl, computationStartInstant, computationEndInstant);
        }
        catch (Exception e) {
            throw new CoreValidInternalException(String.format("Error during core request running for timestamp '%s'", coreValidRequest.getTimestamp()), (Throwable)e);
        }
    }

    private String saveProcessOutputs(List<StudyPointResult> studyPointResults, OffsetDateTime timestamp) {
        return this.fileExporter.exportStudyPointResult(studyPointResults, timestamp);
    }

    private String saveCracInJsonFormat(Crac crac, OffsetDateTime timestamp) {
        MemDataSource memDataSource = new MemDataSource();
        String jsonCracFileName = String.format("crac_%s.json", timestamp.toString());
        try (OutputStream os = memDataSource.newOutputStream(jsonCracFileName, false);){
            CracExporters.exportCrac((Crac)crac, (String)"Json", (OutputStream)os);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to save converted CRAC file.", (Throwable)e);
        }
        String cracPath = String.format(ARTIFACTS_S, jsonCracFileName);
        try (InputStream is = memDataSource.newInputStream(jsonCracFileName);){
            this.minioAdapter.uploadFile(cracPath, is);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to upload converted CRAC file.", (Throwable)e);
        }
        return this.minioAdapter.generatePreSignedUrl(cracPath);
    }
}

