/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.study_point;

import com.farao_community.farao.core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StudyPointsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudyPointsImporter.class);

    public static List<StudyPoint> importStudyPoints(InputStream inputStream) {
        return StudyPointsImporter.importStudyPoints((Reader)new InputStreamReader(inputStream));
    }

    public static List<StudyPoint> importStudyPoints(InputStream studyPointsStream, OffsetDateTime timestamp) {
        List allStudyPoints = StudyPointsImporter.importStudyPoints((InputStream)studyPointsStream);
        int period = timestamp.atZoneSameInstant(ZoneId.of("Europe/Paris")).getHour();
        return allStudyPoints.stream().filter(studyPoint -> studyPoint.getPeriod() == period).collect(Collectors.toList());
    }

    private static List<StudyPoint> importStudyPoints(Reader reader) {
        try {
            ArrayList<StudyPoint> studyPoints = new ArrayList<StudyPoint>();
            CSVReader csvReader = new CSVReaderBuilder(reader).withCSVParser((ICSVParser)StudyPointsImporter.buildParser()).build();
            List lines = csvReader.readAll();
            String[] headers = (String[])lines.get(0);
            for (int i = 1; i < lines.size(); ++i) {
                studyPoints.add(StudyPointsImporter.importStudyPoint((String[])headers, (String[])((String[])lines.get(i))));
            }
            return studyPoints;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred during parsing.", (Throwable)e);
            throw new CoreValidInvalidDataException("Exception occurred during parsing study point file", (Throwable)e);
        }
    }

    private static StudyPoint importStudyPoint(String[] headers, String[] data) throws ParseException {
        int period = Integer.parseInt(data[0]);
        String id = data[1];
        HashMap<String, Double> positions = new HashMap<String, Double>();
        for (int i = 2; i < data.length; ++i) {
            positions.put(headers[i], NumberFormat.getInstance(Locale.FRANCE).parse(data[i]).doubleValue());
        }
        return new StudyPoint(period, id, positions);
    }

    private static CSVParser buildParser() {
        return new CSVParserBuilder().withSeparator(';').build();
    }
}

