/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.farao_community.farao.core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.gridcapa_core_valid.app.configuration.UrlWhitelistConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringJoiner;
import org.springframework.stereotype.Component;

@Component
public class UrlValidationService {
    private final UrlWhitelistConfiguration urlWhitelistConfiguration;

    public UrlValidationService(UrlWhitelistConfiguration urlWhitelistConfiguration) {
        this.urlWhitelistConfiguration = urlWhitelistConfiguration;
    }

    public InputStream openUrlStream(String urlString) {
        if (this.urlWhitelistConfiguration.getWhitelist().stream().noneMatch(urlString::startsWith)) {
            StringJoiner sj = new StringJoiner(", ", "Whitelist: ", ".");
            this.urlWhitelistConfiguration.getWhitelist().forEach(sj::add);
            throw new CoreValidInvalidDataException(String.format("URL '%s' is not part of application's whitelisted url's %s", urlString, sj));
        }
        try {
            URL url = new URL(urlString);
            return url.openStream();
        }
        catch (IOException e) {
            throw new CoreValidInvalidDataException(String.format("Cannot download FileResource file from URL '%s'", urlString), (Throwable)e);
        }
    }
}

