/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.powsybl.iidm.import_.Importers;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class NetworkHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkHandler.class);
    private static final String ALEGRO_GEN_BE = "XLI_OB1B_generator";
    private static final String ALEGRO_GEN_DE = "XLI_OB1A_generator";

    public static Network loadNetwork(String filename, InputStream inputStream) {
        LOGGER.info("IIDM import of network : {}", (Object)filename);
        Network network = Importers.loadNetwork((String)filename, (InputStream)inputStream);
        NetworkHandler.processNetworkForCore((Network)network);
        return network;
    }

    private static void processNetworkForCore(Network network) {
        NetworkHandler.createGeneratorOnAlegroNodes((Network)network);
    }

    private static void createGeneratorOnAlegroNodes(Network network) {
        NetworkHandler.createGeneratorOnXnode((Network)network, (String)"XLI_OB1B");
        NetworkHandler.createGeneratorOnXnode((Network)network, (String)"XLI_OB1A");
    }

    private static void createGeneratorOnXnode(Network network, String xNodeId) {
        Optional<DanglingLine> danglingLine = network.getDanglingLineStream().filter(dl -> dl.getUcteXnodeCode().equals(xNodeId)).findAny();
        if (danglingLine.isPresent() && danglingLine.get().getTerminal().isConnected()) {
            Bus xNodeBus = danglingLine.get().getTerminal().getBusBreakerView().getConnectableBus();
            ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)xNodeBus.getVoltageLevel().newGenerator().setBus(xNodeBus.getId())).setEnsureIdUnicity(true)).setId(xNodeId + "_generator")).setMaxP(9999.0).setMinP(0.0).setTargetP(0.0).setTargetQ(0.0).setTargetV(xNodeBus.getVoltageLevel().getNominalV()).setVoltageRegulatorOn(false).add().newMinMaxReactiveLimits().setMaxQ(99999.0).setMinQ(99999.0).add();
        }
    }

    public static void removeAlegroVirtualGeneratorsFromNetwork(Network network) {
        Optional.ofNullable(network.getGenerator("XLI_OB1B_generator")).ifPresent(Connectable::remove);
        Optional.ofNullable(network.getGenerator("XLI_OB1A_generator")).ifPresent(Connectable::remove);
    }
}

