/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app;

import com.farao_community.farao.commons.ZonalData;
import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.core_valid.api.exception.CoreValidInvalidDataException;
import com.farao_community.farao.core_valid.api.resource.CoreValidFileResource;
import com.farao_community.farao.core_valid.api.resource.CoreValidRequest;
import com.farao_community.farao.core_valid.api.resource.CoreValidResponse;
import com.farao_community.farao.data.glsk.api.GlskDocument;
import com.farao_community.farao.data.glsk.api.io.GlskDocumentImporters;
import com.farao_community.farao.data.refprog.reference_program.ReferenceProgram;
import com.farao_community.farao.data.refprog.refprog_xml_importer.RefProgImporter;
import com.farao_community.farao.gridcapa_core_valid.app.NetworkHandler;
import com.farao_community.farao.gridcapa_core_valid.app.UrlValidationService;
import com.farao_community.farao.gridcapa_core_valid.app.net_position.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointsImporter;
import com.powsybl.iidm.network.Network;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CoreValidHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreValidHandler.class);
    private final UrlValidationService urlValidationService;
    private final StudyPointService studyPointService;

    public CoreValidHandler(UrlValidationService urlValidationService, StudyPointService studyPointService) {
        this.urlValidationService = urlValidationService;
        this.studyPointService = studyPointService;
    }

    public CoreValidResponse handleCoreValidRequest(CoreValidRequest coreValidRequest) {
        try {
            InputStream networkStream = this.urlValidationService.openUrlStream(coreValidRequest.getCgm().getUrl());
            Network network = NetworkHandler.loadNetwork((String)coreValidRequest.getCgm().getFilename(), (InputStream)networkStream);
            ReferenceProgram referenceProgram = this.importReferenceProgram(coreValidRequest.getRefProg(), coreValidRequest.getTimestamp());
            Map coreNetPositions = NetPositionsHandler.computeCoreReferenceNetPositions((ReferenceProgram)referenceProgram);
            GlskDocument glskDocument = this.importGlskFile(coreValidRequest.getGlsk());
            List studyPoints = this.importStudyPoints(coreValidRequest.getStudyPoints(), coreValidRequest.getTimestamp());
            ZonalData scalableZonalData = glskDocument.getZonalScalable(network, coreValidRequest.getTimestamp().toInstant());
            studyPoints.forEach(studyPoint -> this.studyPointService.computeStudyPoint(studyPoint, network, scalableZonalData, coreNetPositions));
            return new CoreValidResponse(coreValidRequest.getId());
        }
        catch (Exception e) {
            throw new CoreValidInternalException(String.format("Error during core request running for timestamp '%s'", coreValidRequest.getTimestamp()), (Throwable)e);
        }
    }

    GlskDocument importGlskFile(CoreValidFileResource glskFileResource) {
        GlskDocument glskDocument;
        block8: {
            InputStream glskStream = this.urlValidationService.openUrlStream(glskFileResource.getUrl());
            try {
                LOGGER.info("Import of Glsk file {} ", (Object)glskFileResource.getFilename());
                glskDocument = GlskDocumentImporters.importGlsk((InputStream)glskStream);
                if (glskStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (glskStream != null) {
                        try {
                            glskStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download reference program file from URL '%s'", glskFileResource.getUrl()), (Throwable)e);
                }
            }
            glskStream.close();
        }
        return glskDocument;
    }

    ReferenceProgram importReferenceProgram(CoreValidFileResource refProgFile, OffsetDateTime timestamp) {
        ReferenceProgram referenceProgram;
        block8: {
            InputStream refProgStream = this.urlValidationService.openUrlStream(refProgFile.getUrl());
            try {
                referenceProgram = RefProgImporter.importRefProg((InputStream)refProgStream, (OffsetDateTime)timestamp);
                if (refProgStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (refProgStream != null) {
                        try {
                            refProgStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download reference program file from URL '%s'", refProgFile.getUrl()), (Throwable)e);
                }
            }
            refProgStream.close();
        }
        return referenceProgram;
    }

    private List<StudyPoint> importStudyPoints(CoreValidFileResource studyPointsFileResource, OffsetDateTime timestamp) {
        List list;
        block8: {
            InputStream studyPointsStream = this.urlValidationService.openUrlStream(studyPointsFileResource.getUrl());
            try {
                LOGGER.info("Import of study points from {} file for timestamp {} ", (Object)studyPointsFileResource.getFilename(), (Object)timestamp);
                list = StudyPointsImporter.importStudyPoints((InputStream)studyPointsStream, (OffsetDateTime)timestamp);
                if (studyPointsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (studyPointsStream != null) {
                        try {
                            studyPointsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreValidInvalidDataException(String.format("Cannot download study points file from URL '%s'", studyPointsFileResource.getUrl()), (Throwable)e);
                }
            }
            studyPointsStream.close();
        }
        return list;
    }
}

