/*
 * Decompiled with CFR 0.152.
 */
package com.farao_community.farao.gridcapa_core_valid.app.study_point;

import com.farao_community.farao.commons.CountryEICode;
import com.farao_community.farao.commons.ZonalData;
import com.farao_community.farao.core_valid.api.exception.CoreValidInternalException;
import com.farao_community.farao.gridcapa_core_valid.app.CoreAreasId;
import com.farao_community.farao.gridcapa_core_valid.app.MinioAdapter;
import com.farao_community.farao.gridcapa_core_valid.app.NetworkHandler;
import com.farao_community.farao.gridcapa_core_valid.app.net_position.NetPositionsHandler;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPoint;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointResult;
import com.farao_community.farao.gridcapa_core_valid.app.study_point.StudyPointService;
import com.powsybl.action.util.Scalable;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.MemDataSource;
import com.powsybl.iidm.export.Exporters;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Network;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StudyPointService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudyPointService.class);
    private static final double DEFAULT_PMAX = 9999.0;
    private static final double DEFAULT_PMIN = -9999.0;
    public static final String ARTIFACTS_S = "artifacts/%s";
    private final MinioAdapter minioAdapter;

    public StudyPointService(MinioAdapter minioAdapter) {
        this.minioAdapter = minioAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StudyPointResult computeStudyPoint(StudyPoint studyPoint, Network network, ZonalData<Scalable> scalableZonalData, Map<String, Double> coreNetPositions) {
        LOGGER.info("Running computation for study point {} ", (Object)studyPoint.getId());
        StudyPointResult result = new StudyPointResult(studyPoint.getId());
        String initialVariant = network.getVariantManager().getWorkingVariantId();
        String newVariant = initialVariant + "_" + studyPoint.getId();
        network.getVariantManager().cloneVariant(initialVariant, newVariant);
        network.getVariantManager().setWorkingVariant(newVariant);
        try {
            Map initGenerators = this.setPminPmaxToDefaultValue(network, scalableZonalData);
            NetPositionsHandler.shiftNetPositionToStudyPoint((Network)network, (StudyPoint)studyPoint, scalableZonalData, coreNetPositions);
            this.resetInitialPminPmax(network, scalableZonalData, initGenerators);
            String url = this.saveShiftedCgm(network, studyPoint);
            result.setStatus(StudyPointResult.Status.SUCCESS);
            result.setShiftedCgmUrl(url);
        }
        catch (Exception e) {
            LOGGER.error("Error during study point {} computation", (Object)studyPoint.getId(), (Object)e);
            result.setStatus(StudyPointResult.Status.ERROR);
        }
        finally {
            network.getVariantManager().setWorkingVariant(initialVariant);
            network.getVariantManager().removeVariant(newVariant);
        }
        return result;
    }

    private String saveShiftedCgm(Network network, StudyPoint studyPoint) {
        String fileName = network.getNameOrId() + "_" + studyPoint.getId() + ".uct";
        String networkPath = String.format(ARTIFACTS_S, fileName);
        MemDataSource memDataSource = new MemDataSource();
        NetworkHandler.removeAlegroVirtualGeneratorsFromNetwork((Network)network);
        Exporters.export((String)"UCTE", (Network)network, (Properties)new Properties(), (DataSource)memDataSource);
        try (InputStream is = memDataSource.newInputStream("", "uct");){
            LOGGER.info("Uploading shifted cgm to {}", (Object)networkPath);
            this.minioAdapter.uploadFile(networkPath, is);
        }
        catch (IOException e) {
            throw new CoreValidInternalException("Error while trying to save shifted network", (Throwable)e);
        }
        return this.minioAdapter.generatePreSignedUrl(networkPath);
    }

    private Map<String, InitGenerator> setPminPmaxToDefaultValue(Network network, ZonalData<Scalable> scalableZonalData) {
        HashMap<String, InitGenerator> initGenerators = new HashMap<String, InitGenerator>();
        CoreAreasId.getCountriesId().forEach(zone -> {
            String zoneEiCode = new CountryEICode(Country.valueOf((String)zone)).getCode();
            Scalable scalable = (Scalable)scalableZonalData.getData(zoneEiCode);
            if (scalable != null) {
                List<Generator> generators = scalable.filterInjections(network).stream().filter(injection -> injection instanceof Generator).map(injection -> (Generator)injection).collect(Collectors.toList());
                generators.forEach(generator -> {
                    if (Double.isNaN(generator.getTargetP())) {
                        generator.setTargetP(0.0);
                    }
                    InitGenerator initGenerator = new InitGenerator();
                    initGenerator.setpMin(generator.getMinP());
                    initGenerator.setpMax(generator.getMaxP());
                    initGenerators.put(generator.getId(), initGenerator);
                    generator.setMinP(-9999.0);
                    generator.setMaxP(9999.0);
                });
            }
        });
        LOGGER.info("Pmax and Pmin are set to default values for network {}", (Object)network.getNameOrId());
        return initGenerators;
    }

    private void resetInitialPminPmax(Network network, ZonalData<Scalable> scalableZonalData, Map<String, InitGenerator> initGenerators) {
        CoreAreasId.getCountriesId().forEach(zone -> {
            String zoneEiCode = new CountryEICode(Country.valueOf((String)zone)).getCode();
            Scalable scalable = (Scalable)scalableZonalData.getData(zoneEiCode);
            if (scalable != null) {
                List<Generator> generators = scalable.filterInjections(network).stream().filter(injection -> injection instanceof Generator).map(injection -> (Generator)injection).collect(Collectors.toList());
                generators.forEach(generator -> {
                    generator.setMaxP(Math.max(generator.getTargetP(), ((InitGenerator)initGenerators.get(generator.getId())).getpMax()));
                    generator.setMinP(Math.min(generator.getTargetP(), ((InitGenerator)initGenerators.get(generator.getId())).getpMin()));
                });
            }
        });
        LOGGER.info("Pmax and Pmin are reset to initial values for network {}", (Object)network.getNameOrId());
    }
}

