/*
 * Decompiled with CFR 0.152.
 */
package com.fanjun.keeplive.service;

import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import com.fanjun.keeplive.config.NotificationUtils;
import com.fanjun.keeplive.receiver.NotificationClickReceiver;
import com.fanjun.keeplive.service.GuardAidl;
import com.fanjun.keeplive.service.LocalService;

public final class RemoteService
extends Service {
    private MyBilder mBilder;
    private boolean mIsBoundLocalService;
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Intent remoteService = new Intent((Context)RemoteService.this, LocalService.class);
            RemoteService.this.startService(remoteService);
            RemoteService.this.mIsBoundLocalService = RemoteService.this.bindService(new Intent((Context)RemoteService.this, LocalService.class), RemoteService.this.connection, 8);
            PowerManager pm = (PowerManager)RemoteService.this.getSystemService("power");
            boolean isScreenOn = pm.isScreenOn();
            if (isScreenOn) {
                RemoteService.this.sendBroadcast(new Intent("_ACTION_SCREEN_ON"));
            } else {
                RemoteService.this.sendBroadcast(new Intent("_ACTION_SCREEN_OFF"));
            }
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
        }
    };

    public void onCreate() {
        super.onCreate();
        if (this.mBilder == null) {
            this.mBilder = new MyBilder();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.mBilder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            this.mIsBoundLocalService = this.bindService(new Intent((Context)this, LocalService.class), this.connection, 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.connection != null) {
            try {
                if (this.mIsBoundLocalService) {
                    this.unbindService(this.connection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final class MyBilder
    extends GuardAidl.Stub {
        private MyBilder() {
        }

        @Override
        public void wakeUp(String title, String discription, int iconRes) throws RemoteException {
            if (Build.VERSION.SDK_INT < 25) {
                Intent intent2 = new Intent(RemoteService.this.getApplicationContext(), NotificationClickReceiver.class);
                intent2.setAction("CLICK_NOTIFICATION");
                Notification notification = NotificationUtils.createNotification((Context)RemoteService.this, title, discription, iconRes, intent2);
                RemoteService.this.startForeground(13691, notification);
            }
        }
    }
}

