/*
 * Decompiled with CFR 0.152.
 */
package com.fanjun.keeplive.service;

import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import com.fanjun.keeplive.KeepLive;
import com.fanjun.keeplive.R;
import com.fanjun.keeplive.config.NotificationUtils;
import com.fanjun.keeplive.receiver.NotificationClickReceiver;
import com.fanjun.keeplive.receiver.OnepxReceiver;
import com.fanjun.keeplive.service.GuardAidl;
import com.fanjun.keeplive.service.HideForegroundService;
import com.fanjun.keeplive.service.RemoteService;

public final class LocalService
extends Service {
    private OnepxReceiver mOnepxReceiver;
    private ScreenStateReceiver screenStateReceiver;
    private boolean isPause = true;
    private MediaPlayer mediaPlayer;
    private MyBilder mBilder;
    private Handler handler;
    private boolean mIsBoundRemoteService;
    private ServiceConnection connection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Intent remoteService = new Intent((Context)LocalService.this, RemoteService.class);
            LocalService.this.startService(remoteService);
            Intent intent = new Intent((Context)LocalService.this, RemoteService.class);
            LocalService.this.mIsBoundRemoteService = LocalService.this.bindService(intent, LocalService.this.connection, 8);
            PowerManager pm = (PowerManager)LocalService.this.getSystemService("power");
            boolean isScreenOn = pm.isScreenOn();
            if (isScreenOn) {
                LocalService.this.sendBroadcast(new Intent("_ACTION_SCREEN_ON"));
            } else {
                LocalService.this.sendBroadcast(new Intent("_ACTION_SCREEN_OFF"));
            }
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                if (LocalService.this.mBilder != null && KeepLive.foregroundNotification != null) {
                    GuardAidl guardAidl = GuardAidl.Stub.asInterface(service);
                    guardAidl.wakeUp(KeepLive.foregroundNotification.getTitle(), KeepLive.foregroundNotification.getDescription(), KeepLive.foregroundNotification.getIconRes());
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        if (this.mBilder == null) {
            this.mBilder = new MyBilder();
        }
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.isPause = pm.isScreenOn();
        if (this.handler == null) {
            this.handler = new Handler();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.mBilder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = MediaPlayer.create((Context)this, (int)R.raw.novioce);
            if (this.mediaPlayer != null) {
                this.mediaPlayer.setVolume(0.0f, 0.0f);
                this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mediaPlayer) {
                        if (!LocalService.this.isPause) {
                            if (KeepLive.runMode == KeepLive.RunMode.ROGUE) {
                                LocalService.this.play();
                            } else if (LocalService.this.handler != null) {
                                LocalService.this.handler.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        LocalService.this.play();
                                    }
                                }, 5000L);
                            }
                        }
                    }
                });
                this.play();
            }
        }
        if (this.mOnepxReceiver == null) {
            this.mOnepxReceiver = new OnepxReceiver();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        this.registerReceiver(this.mOnepxReceiver, intentFilter);
        if (this.screenStateReceiver == null) {
            this.screenStateReceiver = new ScreenStateReceiver();
        }
        IntentFilter intentFilter2 = new IntentFilter();
        intentFilter2.addAction("_ACTION_SCREEN_OFF");
        intentFilter2.addAction("_ACTION_SCREEN_ON");
        this.registerReceiver(this.screenStateReceiver, intentFilter2);
        if (KeepLive.foregroundNotification != null) {
            Intent intent2 = new Intent(this.getApplicationContext(), NotificationClickReceiver.class);
            intent2.setAction("CLICK_NOTIFICATION");
            Notification notification = NotificationUtils.createNotification((Context)this, KeepLive.foregroundNotification.getTitle(), KeepLive.foregroundNotification.getDescription(), KeepLive.foregroundNotification.getIconRes(), intent2);
            this.startForeground(13691, notification);
        }
        try {
            Intent intent3 = new Intent((Context)this, RemoteService.class);
            this.mIsBoundRemoteService = this.bindService(intent3, this.connection, 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Build.VERSION.SDK_INT < 25) {
                this.startService(new Intent((Context)this, HideForegroundService.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (KeepLive.keepLiveService != null) {
            KeepLive.keepLiveService.onWorking();
        }
        return 1;
    }

    private void play() {
        if (this.mediaPlayer != null && !this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.start();
        }
    }

    private void pause() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.connection != null) {
            try {
                if (this.mIsBoundRemoteService) {
                    this.unbindService(this.connection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.unregisterReceiver(this.mOnepxReceiver);
            this.unregisterReceiver(this.screenStateReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (KeepLive.keepLiveService != null) {
            KeepLive.keepLiveService.onStop();
        }
    }

    private final class MyBilder
    extends GuardAidl.Stub {
        private MyBilder() {
        }

        @Override
        public void wakeUp(String title, String discription, int iconRes) throws RemoteException {
        }
    }

    private class ScreenStateReceiver
    extends BroadcastReceiver {
        private ScreenStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("_ACTION_SCREEN_OFF")) {
                LocalService.this.isPause = false;
                LocalService.this.play();
            } else if (intent.getAction().equals("_ACTION_SCREEN_ON")) {
                LocalService.this.isPause = true;
                LocalService.this.pause();
            }
        }
    }
}

