/*
 * Decompiled with CFR 0.152.
 */
package com.fanjun.keeplive.service;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.fanjun.keeplive.KeepLive;
import com.fanjun.keeplive.config.NotificationUtils;
import com.fanjun.keeplive.receiver.NotificationClickReceiver;
import com.fanjun.keeplive.service.LocalService;
import com.fanjun.keeplive.service.RemoteService;
import java.util.List;

@RequiresApi(api=21)
public final class JobHandlerService
extends JobService {
    private JobScheduler mJobScheduler;

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.startService((Context)this);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mJobScheduler = (JobScheduler)this.getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(startId++, new ComponentName(this.getPackageName(), JobHandlerService.class.getName()));
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setMinimumLatency(30000L);
                builder.setOverrideDeadline(30000L);
                builder.setMinimumLatency(30000L);
                builder.setBackoffCriteria(30000L, 0);
            } else {
                builder.setPeriodic(30000L);
            }
            builder.setRequiredNetworkType(1);
            builder.setRequiresCharging(true);
            this.mJobScheduler.schedule(builder.build());
        }
        return 1;
    }

    private void startService(Context context) {
        if (Build.VERSION.SDK_INT >= 26 && KeepLive.foregroundNotification != null) {
            Intent intent2 = new Intent(this.getApplicationContext(), NotificationClickReceiver.class);
            intent2.setAction("CLICK_NOTIFICATION");
            Notification notification = NotificationUtils.createNotification((Context)this, KeepLive.foregroundNotification.getTitle(), KeepLive.foregroundNotification.getDescription(), KeepLive.foregroundNotification.getIconRes(), intent2);
            this.startForeground(13691, notification);
        }
        Intent localIntent = new Intent(context, LocalService.class);
        Intent guardIntent = new Intent(context, RemoteService.class);
        this.startService(localIntent);
        this.startService(guardIntent);
    }

    public boolean onStartJob(JobParameters jobParameters) {
        if (!this.isServiceRunning(this.getApplicationContext(), "com.fanjun.keeplive.service.LocalService") || !this.isRunningTaskExist(this.getApplicationContext(), this.getPackageName() + ":remote")) {
            this.startService((Context)this);
        }
        return false;
    }

    public boolean onStopJob(JobParameters jobParameters) {
        if (!this.isServiceRunning(this.getApplicationContext(), "com.fanjun.keeplive.service.LocalService") || !this.isRunningTaskExist(this.getApplicationContext(), this.getPackageName() + ":remote")) {
            this.startService((Context)this);
        }
        return false;
    }

    private boolean isServiceRunning(Context ctx, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        List servicesList = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (servicesList != null) {
            for (ActivityManager.RunningServiceInfo si : servicesList) {
                if (!className.equals(si.service.getClassName())) continue;
                isRunning = true;
            }
        }
        return isRunning;
    }

    private boolean isRunningTaskExist(Context context, String processName) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List processList = am.getRunningAppProcesses();
        if (processList != null) {
            for (ActivityManager.RunningAppProcessInfo info : processList) {
                if (!info.processName.equals(processName)) continue;
                return true;
            }
        }
        return false;
    }
}

