/*
 * Decompiled with CFR 0.152.
 */
package com.fanjun.keeplive;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import com.fanjun.keeplive.config.ForegroundNotification;
import com.fanjun.keeplive.config.KeepLiveService;
import com.fanjun.keeplive.service.JobHandlerService;
import com.fanjun.keeplive.service.LocalService;
import com.fanjun.keeplive.service.RemoteService;
import java.util.List;

public final class KeepLive {
    public static ForegroundNotification foregroundNotification = null;
    public static KeepLiveService keepLiveService = null;
    public static RunMode runMode = null;

    public static void startWork(@NonNull Application application, @NonNull RunMode runMode, @NonNull ForegroundNotification foregroundNotification, @NonNull KeepLiveService keepLiveService) {
        if (KeepLive.isMain(application)) {
            KeepLive.foregroundNotification = foregroundNotification;
            KeepLive.keepLiveService = keepLiveService;
            KeepLive.runMode = runMode;
            if (Build.VERSION.SDK_INT >= 21) {
                Intent intent = new Intent((Context)application, JobHandlerService.class);
                if (Build.VERSION.SDK_INT >= 26) {
                    application.startForegroundService(intent);
                } else {
                    application.startService(intent);
                }
            } else {
                Intent localIntent = new Intent((Context)application, LocalService.class);
                Intent guardIntent = new Intent((Context)application, RemoteService.class);
                application.startService(localIntent);
                application.startService(guardIntent);
            }
        }
    }

    private static boolean isMain(Application application) {
        int pid = Process.myPid();
        String processName = "";
        ActivityManager mActivityManager = (ActivityManager)application.getSystemService("activity");
        List runningAppProcessInfos = mActivityManager.getRunningAppProcesses();
        if (runningAppProcessInfos != null) {
            String packageName;
            for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
                if (appProcess.pid != pid) continue;
                processName = appProcess.processName;
                break;
            }
            if (processName.equals(packageName = application.getPackageName())) {
                return true;
            }
        }
        return false;
    }

    public static enum RunMode {
        ENERGY,
        ROGUE;

    }
}

