/*
 * Decompiled with CFR 0.152.
 */
package com.fanap.podasync;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.fanap.podasync.AsyncListener;
import com.fanap.podasync.AsyncListenerManager;
import com.fanap.podasync.model.ClientMessage;
import com.fanap.podasync.model.Message;
import com.fanap.podasync.model.MessageWrapperVo;
import com.fanap.podasync.model.PeerInfo;
import com.fanap.podasync.model.RegistrationRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.neovisionaries.ws.client.ThreadType;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class Async {
    long currentTime = 0L;
    private WebSocket webSocket;
    private static final int SOCKET_CLOSE_TIMEOUT = 110000;
    private WebSocket webSocketReconnect;
    private static final String TAG = "Async ";
    private static volatile Async instance;
    private boolean isServerRegister;
    private boolean rawLog;
    private boolean isDeviceRegister;
    private static SharedPreferences sharedPrefs;
    private MessageWrapperVo messageWrapperVo;
    private static AsyncListenerManager asyncListenerManager;
    private Gson gson = new GsonBuilder().create();
    private String errorMessage;
    private long lastSentMessageTime;
    private long lastReceiveMessageTime;
    private String message;
    private String state;
    private String appId;
    private String peerId;
    private String deviceID;
    private ArrayList<String> asyncQueue = new ArrayList();
    private String serverAddress;
    private static final Handler pingHandler;
    private static final Handler reconnectHandler;
    private static final Handler socketCloseHandler;
    private String token;
    private String serverName;
    private String ssoHost;
    private int retryStep = 1;
    private boolean reconnectOnClose = false;
    private boolean log;
    private long connectionCheckTimeout = 10000L;
    private long JSTimeLatency = 100L;

    private Async() {
    }

    public static Async getInstance(Context context) {
        if (instance == null) {
            sharedPrefs = context.getSharedPreferences("PREFERENCE", 0);
            instance = new Async();
        }
        return instance;
    }

    private void onEvent(WebSocket webSocket) {
        webSocket.addListener(new WebSocketListener(){

            public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
                asyncListenerManager.callOnStateChanged(newState.toString());
                Async.this.setState(newState.toString());
                if (Async.this.log) {
                    Log.d((String)Async.TAG, (String)("State Is Now " + newState.toString()));
                }
                switch (newState) {
                    case OPEN: {
                        reconnectHandler.removeCallbacksAndMessages(null);
                        Async.this.retryStep = 1;
                        break;
                    }
                    case CLOSED: {
                        Async.this.stopSocket();
                        if (Async.this.reconnectOnClose) {
                            Async.this.retryReconnect();
                            break;
                        }
                        if (!Async.this.log) break;
                        Log.e((String)Async.TAG, (String)"Socket Closed!");
                        break;
                    }
                    case CONNECTING: {
                        break;
                    }
                }
            }

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
            }

            public void onConnectError(WebSocket websocket, WebSocketException cause) throws Exception {
                if (Async.this.log) {
                    Log.e((String)"onConnected", (String)cause.toString());
                }
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                if (Async.this.log) {
                    Log.e((String)"Disconnected", (String)serverCloseFrame.getCloseReason());
                }
                asyncListenerManager.callOnDisconnected(serverCloseFrame.getCloseReason());
            }

            public void onFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onContinuationFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onTextFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onBinaryFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onCloseFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                if (Async.this.log) {
                    Log.i((String)Async.TAG, (String)"onCloseFrame");
                }
                if (Async.this.log) {
                    Log.i((String)Async.TAG, (String)frame.getCloseReason());
                }
            }

            public void onPingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onPongFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onTextMessage(WebSocket websocket, String textMessage) throws Exception {
                if (Async.this.rawLog) {
                    Log.d((String)Async.TAG, (String)textMessage);
                }
                int type = 0;
                Async.this.lastReceiveMessageTime = new Date().getTime();
                ClientMessage clientMessage = (ClientMessage)Async.this.gson.fromJson(textMessage, ClientMessage.class);
                if (clientMessage != null) {
                    type = clientMessage.getType();
                }
                Async.this.scheduleCloseSocket();
                int currentMessageType = type;
                switch (currentMessageType) {
                    case 6: {
                        Async.this.handleOnAck(clientMessage);
                        break;
                    }
                    case 2: {
                        Async.this.handleOnDeviceRegister(websocket, clientMessage);
                        break;
                    }
                    case -99: {
                        Async.this.handleOnErrorMessage(clientMessage);
                        break;
                    }
                    case 4: {
                        Async.this.handleOnMessageAckNeeded(websocket, clientMessage);
                        break;
                    }
                    case 5: {
                        Async.this.handleOnMessageAckNeeded(websocket, clientMessage);
                        break;
                    }
                    case 3: {
                        Async.this.handleOnMessage(clientMessage);
                        break;
                    }
                    case -3: {
                        break;
                    }
                    case 0: {
                        Async.this.handleOnPing(websocket, clientMessage);
                        break;
                    }
                    case 1: {
                        Async.this.handleOnServerRegister(textMessage);
                    }
                }
            }

            public void onTextMessage(WebSocket websocket, byte[] data) throws Exception {
            }

            public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
            }

            public void onSendingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onFrameSent(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onFrameUnsent(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onThreadCreated(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
            }

            public void onThreadStarted(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
            }

            public void onThreadStopping(WebSocket websocket, ThreadType threadType, Thread thread) throws Exception {
            }

            public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
                if (Async.this.log) {
                    Log.e((String)Async.TAG, (String)"onError");
                }
                if (Async.this.log) {
                    Log.e((String)Async.TAG, (String)cause.getCause().getMessage());
                }
                asyncListenerManager.callOnError(cause.toString());
            }

            public void onFrameError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
            }

            public void onMessageError(WebSocket websocket, WebSocketException cause, List<WebSocketFrame> frames) throws Exception {
                if (Async.this.log) {
                    Log.e((String)"onMessageError", (String)cause.toString());
                }
            }

            public void onMessageDecompressionError(WebSocket websocket, WebSocketException cause, byte[] compressed) throws Exception {
            }

            public void onTextMessageError(WebSocket websocket, WebSocketException cause, byte[] data) throws Exception {
            }

            public void onSendError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
            }

            public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
            }

            public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
            }

            public void onSendingHandshake(WebSocket websocket, String requestLine, List<String[]> headers) throws Exception {
            }
        });
    }

    public void rawLog(boolean rawLog) {
        this.rawLog = rawLog;
    }

    private void retryReconnect() {
        Async.runOnUiThreadRecconect(new Runnable(){

            @Override
            public void run() {
                try {
                    Async.this.reConnect();
                }
                catch (WebSocketException e) {
                    asyncListenerManager.callOnError(e.getMessage());
                }
                if (Async.this.log) {
                    Log.e((String)Async.TAG, (String)("Async: reConnect in  retryStep " + Async.this.retryStep + " s "));
                }
            }
        }, this.retryStep * 1000);
        if (this.retryStep < 60) {
            this.retryStep *= 2;
        }
    }

    public void isLoggable(boolean log) {
        this.log = log;
    }

    public void connect(String socketServerAddress, String appId, String serverName, String token, String ssoHost, String deviceID) {
        block5: {
            try {
                WebSocketFactory webSocketFactory = new WebSocketFactory();
                SSLSocketFactory.getDefault();
                this.setAppId(appId);
                this.setServerAddress(socketServerAddress);
                this.setToken(token);
                this.setServerName(serverName);
                this.setSsoHost(ssoHost);
                this.webSocket = webSocketFactory.createSocket(socketServerAddress);
                this.onEvent(this.webSocket);
                this.webSocket.setMaxPayloadSize(100);
                this.webSocket.addExtension("permessage-deflate");
                this.webSocket.connectAsynchronously();
                if (deviceID != null && !deviceID.isEmpty()) {
                    this.setDeviceID(deviceID);
                }
            }
            catch (IOException e) {
                if (this.log) {
                    Log.e((String)"Async: connect", (String)e.getMessage());
                }
            }
            catch (Exception e) {
                if (!this.log) break block5;
                Log.e((String)TAG, (String)e.getCause().getMessage());
            }
        }
    }

    public void sendMessage(String textContent, int messageType, long[] receiversId) {
        block2: {
            try {
                Message message = new Message();
                message.setContent(textContent);
                message.setReceivers(receiversId);
                String jsonMessage = this.gson.toJson((Object)message);
                String wrapperJsonString = this.getMessageWrapper(jsonMessage, messageType);
                this.sendData(this.webSocket, wrapperJsonString);
            }
            catch (Exception e) {
                asyncListenerManager.callOnError(e.getCause().getMessage());
                if (!this.log) break block2;
                Log.e((String)"Async: connect", (String)e.getCause().getMessage());
            }
        }
    }

    public void sendMessage(String textContent, int messageType) {
        block3: {
            try {
                long ttl = new Date().getTime();
                Message message = new Message();
                message.setContent(textContent);
                message.setPriority(1);
                message.setPeerName(this.getServerName());
                message.setTtl(ttl);
                String json = this.gson.toJson((Object)message);
                this.messageWrapperVo = new MessageWrapperVo();
                this.messageWrapperVo.setContent(json);
                this.messageWrapperVo.setType(messageType);
                String json1 = this.gson.toJson((Object)this.messageWrapperVo);
                this.sendData(this.webSocket, json1);
                if (this.log) {
                    Log.i((String)TAG, (String)"Send message");
                }
            }
            catch (Exception e) {
                asyncListenerManager.callOnError(e.getCause().getMessage());
                if (!this.log) break block3;
                Log.e((String)"Async: connect", (String)e.getCause().getMessage());
            }
        }
    }

    public void closeSocket() {
        this.webSocket.sendClose();
    }

    public void logOut() {
        this.removePeerId("PEER_ID", null);
        this.isServerRegister = false;
        this.isDeviceRegister = false;
        this.webSocket.sendClose();
    }

    public void setReconnectOnClose(boolean reconnectOnClosed) {
        this.reconnectOnClose = reconnectOnClosed;
    }

    public Async addListener(AsyncListener listener) {
        asyncListenerManager.addListener(listener, this.log);
        return this;
    }

    public Async setListener(AsyncListener listener) {
        asyncListenerManager.clearListeners();
        asyncListenerManager.addListener(listener, this.log);
        return this;
    }

    public Async addListeners(List<AsyncListener> listeners) {
        asyncListenerManager.addListeners(listeners);
        return this;
    }

    public Async removeListener(AsyncListener listener) {
        asyncListenerManager.removeListener(listener);
        return this;
    }

    public List<AsyncListener> getSynchronizedListeners() {
        return asyncListenerManager.getSynchronizedListeners();
    }

    public Async clearListeners() {
        asyncListenerManager.clearListeners();
        return this;
    }

    private void handleOnAck(ClientMessage clientMessage) throws IOException {
        this.setMessage(clientMessage.getContent());
        asyncListenerManager.callOnTextMessage(clientMessage.getContent());
    }

    private void handleOnDeviceRegister(WebSocket websocket, ClientMessage clientMessage) {
        block6: {
            try {
                this.isDeviceRegister = true;
                if (!this.peerIdExistence()) {
                    String peerId = clientMessage.getContent();
                    this.savePeerId(peerId);
                }
                if (this.isServerRegister && this.peerId.equals(this.getPeerId())) {
                    if (websocket.getState() == WebSocketState.OPEN && websocket.getFrameQueueSize() > 0) {
                        // empty if block
                    }
                } else {
                    this.serverRegister(websocket);
                }
            }
            catch (Exception e) {
                if (!this.log) break block6;
                Log.e((String)TAG, (String)e.getCause().getMessage());
            }
        }
    }

    private void serverRegister(WebSocket websocket) {
        if (websocket != null) {
            try {
                RegistrationRequest registrationRequest = new RegistrationRequest();
                registrationRequest.setName(this.getServerName());
                String jsonRegistrationRequestVo = this.gson.toJson((Object)registrationRequest);
                String jsonMessageWrapperVo = this.getMessageWrapper(jsonRegistrationRequestVo, 1);
                this.sendData(websocket, jsonMessageWrapperVo);
            }
            catch (Exception e) {
                if (this.log) {
                    Log.e((String)TAG, (String)e.getCause().getMessage());
                }
            }
        } else if (this.log) {
            Log.e((String)TAG, (String)"WebSocket Is Null");
        }
    }

    private void sendData(WebSocket websocket, String jsonMessageWrapperVo) {
        block10: {
            try {
                this.lastSentMessageTime = new Date().getTime();
                if (jsonMessageWrapperVo != null) {
                    if (this.getState().equals("OPEN")) {
                        if (websocket != null) {
                            websocket.sendText(jsonMessageWrapperVo);
                        } else if (this.log) {
                            Log.e((String)TAG, (String)"webSocket instance is Null");
                        }
                    } else {
                        asyncListenerManager.callOnError("Socket is close");
                        this.asyncQueue.add(jsonMessageWrapperVo);
                    }
                } else if (this.log) {
                    Log.e((String)TAG, (String)"message is Null");
                }
                this.ping();
            }
            catch (Exception e) {
                if (!this.log) break block10;
                Log.e((String)"Async: connect", (String)e.getCause().getMessage());
            }
        }
    }

    private void handleOnErrorMessage(ClientMessage clientMessage) {
        if (this.log) {
            Log.e((String)"Async OnErrorMessage", (String)clientMessage.getContent());
        }
        this.setErrorMessage(clientMessage.getContent());
    }

    private void handleOnMessage(ClientMessage clientMessage) {
        if (clientMessage != null) {
            try {
                this.setMessage(clientMessage.getContent());
                asyncListenerManager.callOnTextMessage(clientMessage.getContent());
            }
            catch (Exception e) {
                if (this.log) {
                    Log.e((String)TAG, (String)e.getCause().getMessage());
                }
            }
        } else if (this.log) {
            Log.e((String)TAG, (String)" clientMessage Is Null");
        }
    }

    private void handleOnPing(WebSocket webSocket, ClientMessage clientMessage) {
        block6: {
            try {
                if (clientMessage.getContent() != null) {
                    if (this.getDeviceId() == null || this.getDeviceId().isEmpty()) {
                        this.setDeviceID(clientMessage.getContent());
                    }
                    this.deviceRegister(webSocket);
                } else if (this.log) {
                    Log.i((String)TAG, (String)"ASYNC_PING_RECEIVED");
                }
            }
            catch (Exception e) {
                if (!this.log) break block6;
                Log.e((String)TAG, (String)e.getCause().getMessage());
            }
        }
    }

    private void handleOnServerRegister(String textMessage) {
        block5: {
            try {
                if (this.log) {
                    Log.i((String)TAG, (String)"SERVER_REGISTERED");
                }
                if (this.log) {
                    Log.i((String)"ASYNC_IS_READY", (String)textMessage);
                }
                asyncListenerManager.callOnStateChanged("ASYNC_READY");
                for (String message : this.asyncQueue) {
                    this.sendData(this.webSocket, message);
                }
                this.isServerRegister = true;
            }
            catch (Exception e) {
                if (!this.log) break block5;
                Log.e((String)TAG, (String)e.getCause().getMessage());
            }
        }
    }

    public boolean isServerRegister() {
        return this.isServerRegister;
    }

    private void handleOnMessageAckNeeded(WebSocket websocket, ClientMessage clientMessage) {
        block5: {
            try {
                if (websocket != null) {
                    this.handleOnMessage(clientMessage);
                    Message messageSenderAckNeeded = new Message();
                    messageSenderAckNeeded.setMessageId(clientMessage.getId());
                    String jsonSenderAckNeeded = this.gson.toJson((Object)messageSenderAckNeeded);
                    String jsonSenderAckNeededWrapper = this.getMessageWrapper(jsonSenderAckNeeded, 6);
                    this.sendData(websocket, jsonSenderAckNeededWrapper);
                } else if (this.log) {
                    Log.e((String)TAG, (String)"WebSocket Is Null ");
                }
            }
            catch (Exception e) {
                if (!this.log) break block5;
                Log.e((String)TAG, (String)e.getCause().getMessage());
            }
        }
    }

    private void deviceRegister(WebSocket websocket) {
        block9: {
            try {
                if (websocket != null) {
                    PeerInfo peerInfo = new PeerInfo();
                    if (this.getPeerId() != null) {
                        peerInfo.setRefresh(true);
                    } else {
                        peerInfo.setRenew(true);
                    }
                    peerInfo.setAppId(this.getAppId());
                    peerInfo.setDeviceId(this.getDeviceId());
                    String peerMessageJson = this.gson.toJson((Object)peerInfo);
                    String jsonPeerInfoWrapper = this.getMessageWrapper(peerMessageJson, 2);
                    this.sendData(websocket, jsonPeerInfoWrapper);
                    if (this.log) {
                        Log.i((String)TAG, (String)"SEND_SERVER_REGISTER");
                    }
                    if (this.log) {
                        Log.d((String)TAG, (String)jsonPeerInfoWrapper);
                    }
                } else if (this.log) {
                    Log.e((String)TAG, (String)"WebSocket Is Null ");
                }
            }
            catch (Exception e) {
                if (!this.log) break block9;
                Log.e((String)TAG, (String)e.getCause().getMessage());
            }
        }
    }

    @NonNull
    private String getMessageWrapper(String json, int messageType) {
        this.messageWrapperVo = new MessageWrapperVo();
        this.messageWrapperVo.setContent(json);
        this.messageWrapperVo.setType(messageType);
        return this.gson.toJson((Object)this.messageWrapperVo);
    }

    private void reConnect() throws WebSocketException {
        this.connect(this.getServerAddress(), this.getAppId(), this.getServerName(), this.getToken(), this.getSsoHost(), null);
    }

    private void removePeerId(String peerId, String nul) {
        SharedPreferences.Editor editor = sharedPrefs.edit();
        editor.putString(peerId, nul);
        editor.apply();
    }

    private void ping() {
        Async.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                long currentTime = new Date().getTime();
                if (currentTime - Async.this.lastSentMessageTime >= Async.this.connectionCheckTimeout - Async.this.JSTimeLatency) {
                    if (!Async.this.getState().equals("CLOSING") || !Async.this.getState().equals("CLOSED")) {
                        block7: {
                            Async.this.message = Async.this.getMessageWrapper("", 0);
                            try {
                                Async.this.sendData(Async.this.webSocket, Async.this.message);
                            }
                            catch (Exception e) {
                                if (!Async.this.log) break block7;
                                Log.e((String)Async.TAG, (String)e.getMessage());
                            }
                        }
                        if (Async.this.log) {
                            Log.i((String)Async.TAG, (String)"SEND_ASYNC_PING");
                        }
                    } else if (Async.this.log) {
                        Log.e((String)"Async Socket Is", (String)"Closed");
                    }
                }
            }
        }, this.connectionCheckTimeout);
    }

    protected static void runOnUiThreadRecconect(Runnable runnable, long delayedTime) {
        if (reconnectHandler != null) {
            reconnectHandler.postDelayed(runnable, delayedTime);
        } else {
            runnable.run();
        }
    }

    protected static void runOnUIThread(Runnable runnable, long delayedTime) {
        if (pingHandler != null) {
            pingHandler.postDelayed(runnable, delayedTime);
        } else {
            runnable.run();
        }
    }

    protected static void runOnUIThreadCloseSocket(Runnable runnable, long delayedTime) {
        if (socketCloseHandler != null) {
            socketCloseHandler.postDelayed(runnable, delayedTime);
        } else {
            runnable.run();
        }
    }

    private void ScheduleCloseSocket() {
        Async.runOnUIThreadCloseSocket(new Runnable(){

            @Override
            public void run() {
                if (Async.this.lastSentMessageTime - Async.this.lastReceiveMessageTime >= 110000L) {
                    Async.this.closeSocket();
                }
            }
        }, 110000L);
    }

    private void scheduleCloseSocket() {
        this.currentTime = new Date().getTime();
        socketCloseHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Async.this.currentTime - Async.this.lastReceiveMessageTime > 10000L) {
                    Async.this.closeSocket();
                }
            }
        }, 10000L);
    }

    public void stopSocket() {
        block4: {
            try {
                if (this.webSocket != null) {
                    this.isServerRegister = false;
                    this.webSocket.disconnect();
                    this.webSocket = null;
                    pingHandler.removeCallbacksAndMessages(null);
                    if (this.log) {
                        Log.i((String)TAG, (String)"Socket Stopped");
                    }
                }
            }
            catch (Exception e) {
                if (!this.log) break block4;
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
    }

    private boolean peerIdExistence() {
        String peerId = sharedPrefs.getString("PEER_ID", null);
        this.setPeerId(peerId);
        boolean isPeerIdExistence = peerId != null;
        return isPeerIdExistence;
    }

    private void savePeerId(String peerId) {
        SharedPreferences.Editor editor = sharedPrefs.edit();
        editor.putString("PEER_ID", peerId);
        editor.apply();
    }

    private static void saveDeviceId(String deviceId) {
        SharedPreferences.Editor editor = sharedPrefs.edit();
        editor.putString("DEVICE_ID", deviceId);
        editor.apply();
    }

    private void setServerName(String serverName) {
        this.serverName = serverName;
    }

    private String getServerName() {
        return this.serverName;
    }

    private String getDeviceId() {
        return this.deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public String getPeerId() {
        return sharedPrefs.getString("PEER_ID", null);
    }

    private void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    private String getAppId() {
        return this.appId;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }

    public String getState() {
        return this.state;
    }

    private void setState(String state) {
        this.state = state;
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    private String getServerAddress() {
        return this.serverAddress;
    }

    private void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    private void setToken(String token) {
        this.token = token;
    }

    private String getToken() {
        return this.token;
    }

    AsyncListenerManager getListenerManager() {
        return asyncListenerManager;
    }

    private void setSsoHost(String ssoHost) {
        this.ssoHost = ssoHost;
    }

    private String getSsoHost() {
        return this.ssoHost;
    }

    static {
        asyncListenerManager = new AsyncListenerManager();
        reconnectHandler = new Handler(Looper.getMainLooper());
        pingHandler = new Handler(Looper.getMainLooper());
        socketCloseHandler = new Handler(Looper.getMainLooper());
    }
}

