/*
 * Decompiled with CFR 0.152.
 */
package com.faendir.maven;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class MessageGenerator
extends AbstractMojo {
    @Parameter(property="inputDirectory", defaultValue="src/main/resources")
    private File inputDirectory;
    @Parameter(property="outputDirectory", defaultValue="target/generated-sources/java")
    private File outputDirectory;
    @Parameter(property="packageName", defaultValue="com.faendir.i18n")
    private String packageName;
    @Parameter(property="className", defaultValue="Messages")
    private String className;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        HashSet keys = new HashSet();
        try {
            Files.walk(this.inputDirectory.toPath(), new FileVisitOption[0]).peek(file -> System.out.println("Walking " + file)).filter(file -> file.toString().endsWith(".properties")).peek(file -> System.out.println("Found " + file)).forEach(file -> {
                try {
                    Properties properties = new Properties();
                    properties.load(new FileReader(file.toFile()));
                    keys.addAll(Collections.list(properties.keys()).stream().map(Object::toString).collect(Collectors.toList()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            for (String key : keys) {
                classBuilder.addField(FieldSpec.builder(String.class, (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, key), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{key}).build());
            }
            JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).skipJavaLangImports(true).indent("    ").build().writeTo(this.outputDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

