/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.builtin;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class BooleanArrayThriftCodec
implements ThriftCodec<boolean[]> {
    @Override
    public ThriftType getType() {
        return ThriftType.array(ThriftType.BOOL);
    }

    @Override
    public boolean[] read(TProtocol protocol) throws Exception {
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol is null");
        return new TProtocolReader(protocol).readBoolArray();
    }

    @Override
    public void write(boolean[] value, TProtocol protocol) throws Exception {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol is null");
        new TProtocolWriter(protocol).writeBoolArray(value);
    }
}

