/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import org.apache.thrift.protocol.TProtocol;

public class DelegateCodec<T>
implements ThriftCodec<T> {
    private final ThriftCodecManager codecManager;
    private final TypeToken<T> typeToken;

    public DelegateCodec(ThriftCodecManager codecManager, Type javaType) {
        this.codecManager = codecManager;
        this.typeToken = TypeToken.of((Type)javaType);
    }

    @Override
    public ThriftType getType() {
        return this.getCodec().getType();
    }

    @Override
    public T read(TProtocol protocol) throws Exception {
        return this.getCodec().read(protocol);
    }

    @Override
    public void write(T value, TProtocol protocol) throws Exception {
        this.getCodec().write(value, protocol);
    }

    private ThriftCodec<T> getCodec() {
        ThriftCodec<T> codec = this.codecManager.getCachedCodecIfPresent(this.typeToken);
        if (codec == null) {
            throw new IllegalStateException("Tried to encodec/decode using a DelegateCodec before the target codec was built (likely a bug in recursive type support)");
        }
        return codec;
    }
}

