/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;

public class PointerEventHelper {
    public static final String POINTER_TYPE_TOUCH = "touch";
    public static final String POINTER_TYPE_PEN = "pen";
    public static final String POINTER_TYPE_MOUSE = "mouse";
    public static final String POINTER_TYPE_UNKNOWN = "";
    public static final String POINTER_CANCEL = "topPointerCancel";
    public static final String POINTER_DOWN = "topPointerDown";
    public static final String POINTER_ENTER = "topPointerEnter";
    public static final String POINTER_LEAVE = "topPointerLeave";
    public static final String POINTER_MOVE = "topPointerMove";
    public static final String POINTER_UP = "topPointerUp";
    public static final String POINTER_OVER = "topPointerOver";
    public static final String POINTER_OUT = "topPointerOut";

    @Nullable
    public static String getDispatchableEventName(EVENT event) {
        switch (event) {
            case LEAVE: {
                return POINTER_LEAVE;
            }
            case DOWN: {
                return POINTER_DOWN;
            }
            case MOVE: {
                return POINTER_MOVE;
            }
            case ENTER: {
                return POINTER_ENTER;
            }
            case CANCEL: {
                return POINTER_CANCEL;
            }
            case UP: {
                return POINTER_UP;
            }
            case OVER: {
                return POINTER_OVER;
            }
            case OUT: {
                return POINTER_OUT;
            }
        }
        FLog.e((String)"ReactNative", (String)("No dispatchable event name for type: " + (Object)((Object)event)));
        return null;
    }

    public static int getButtons(String eventName, String pointerType, int buttonState) {
        if (PointerEventHelper.isExitEvent(eventName)) {
            return 0;
        }
        if (POINTER_TYPE_TOUCH.equals(pointerType)) {
            return 1;
        }
        return buttonState;
    }

    public static int getButtonChange(String pointerType, int lastButtonState, int currentButtonState) {
        if (POINTER_TYPE_TOUCH.equals(pointerType)) {
            return 0;
        }
        int changedMask = currentButtonState ^ lastButtonState;
        if (changedMask == 0) {
            return -1;
        }
        switch (changedMask) {
            case 1: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
        }
        return -1;
    }

    public static boolean isPrimary(int pointerId, int primaryPointerId, MotionEvent event) {
        if (PointerEventHelper.supportsHover(event)) {
            return true;
        }
        return pointerId == primaryPointerId;
    }

    public static String getW3CPointerType(int toolType) {
        switch (toolType) {
            case 1: {
                return POINTER_TYPE_TOUCH;
            }
            case 2: {
                return POINTER_TYPE_PEN;
            }
            case 3: {
                return POINTER_TYPE_MOUSE;
            }
        }
        return POINTER_TYPE_UNKNOWN;
    }

    public static boolean isListening(@Nullable View view, EVENT event) {
        if (view == null) {
            return false;
        }
        switch (event) {
            case DOWN: 
            case CANCEL: 
            case UP: 
            case DOWN_CAPTURE: 
            case UP_CAPTURE: 
            case CANCEL_CAPTURE: {
                return true;
            }
        }
        Integer pointerEvents = (Integer)view.getTag(R.id.pointer_events);
        if (pointerEvents != null) {
            return (pointerEvents & 1 << event.ordinal()) != 0;
        }
        return false;
    }

    public static int getEventCategory(String pointerEventType) {
        if (pointerEventType == null) {
            return 2;
        }
        switch (pointerEventType) {
            case "topPointerDown": 
            case "topPointerCancel": 
            case "topPointerUp": {
                return 3;
            }
            case "topPointerMove": 
            case "topPointerEnter": 
            case "topPointerLeave": 
            case "topPointerOver": 
            case "topPointerOut": {
                return 4;
            }
        }
        return 2;
    }

    public static boolean supportsHover(MotionEvent motionEvent) {
        int source = motionEvent.getSource();
        return source == 8194 || source == 2;
    }

    public static boolean isExitEvent(String eventName) {
        switch (eventName) {
            case "topPointerUp": 
            case "topPointerLeave": 
            case "topPointerOut": {
                return true;
            }
        }
        return false;
    }

    public static double getPressure(int buttonState, String eventName) {
        if (PointerEventHelper.isExitEvent(eventName)) {
            return 0.0;
        }
        boolean inActiveButtonState = buttonState != 0;
        return inActiveButtonState ? 0.5 : 0.0;
    }

    public static boolean isBubblingEvent(String eventName) {
        switch (eventName) {
            case "topPointerUp": 
            case "topPointerDown": 
            case "topPointerOver": 
            case "topPointerOut": 
            case "topPointerMove": 
            case "topPointerCancel": {
                return true;
            }
        }
        return false;
    }

    public static enum EVENT {
        CANCEL,
        CANCEL_CAPTURE,
        DOWN,
        DOWN_CAPTURE,
        ENTER,
        ENTER_CAPTURE,
        LEAVE,
        LEAVE_CAPTURE,
        MOVE,
        MOVE_CAPTURE,
        UP,
        UP_CAPTURE,
        OUT,
        OUT_CAPTURE,
        OVER,
        OVER_CAPTURE;

    }
}

