/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;

public class DisplayMetricsHolder {
    @Nullable
    private static DisplayMetrics sWindowDisplayMetrics;
    @Nullable
    private static DisplayMetrics sScreenDisplayMetrics;

    public static void setWindowDisplayMetrics(DisplayMetrics displayMetrics) {
        sWindowDisplayMetrics = displayMetrics;
    }

    public static void initDisplayMetricsIfNotInitialized(Context context) {
        if (DisplayMetricsHolder.getScreenDisplayMetrics() != null) {
            return;
        }
        DisplayMetricsHolder.initDisplayMetrics(context);
    }

    public static void initDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        DisplayMetricsHolder.setWindowDisplayMetrics(displayMetrics);
        DisplayMetrics screenDisplayMetrics = new DisplayMetrics();
        screenDisplayMetrics.setTo(displayMetrics);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Assertions.assertNotNull((Object)wm, (String)"WindowManager is null!");
        Display display = wm.getDefaultDisplay();
        display.getRealMetrics(screenDisplayMetrics);
        DisplayMetricsHolder.setScreenDisplayMetrics(screenDisplayMetrics);
    }

    public static DisplayMetrics getWindowDisplayMetrics() {
        return sWindowDisplayMetrics;
    }

    public static void setScreenDisplayMetrics(DisplayMetrics screenDisplayMetrics) {
        sScreenDisplayMetrics = screenDisplayMetrics;
    }

    public static DisplayMetrics getScreenDisplayMetrics() {
        return sScreenDisplayMetrics;
    }

    public static WritableMap getDisplayMetricsWritableMap(double fontScale) {
        Assertions.assertCondition((sWindowDisplayMetrics != null && sScreenDisplayMetrics != null ? 1 : 0) != 0, (String)"DisplayMetricsHolder must be initialized with initDisplayMetricsIfNotInitialized or initDisplayMetrics");
        WritableNativeMap result = new WritableNativeMap();
        result.putMap("windowPhysicalPixels", DisplayMetricsHolder.getPhysicalPixelsWritableMap(sWindowDisplayMetrics, fontScale));
        result.putMap("screenPhysicalPixels", DisplayMetricsHolder.getPhysicalPixelsWritableMap(sScreenDisplayMetrics, fontScale));
        return result;
    }

    private static WritableMap getPhysicalPixelsWritableMap(DisplayMetrics displayMetrics, double fontScale) {
        WritableNativeMap result = new WritableNativeMap();
        result.putInt("width", displayMetrics.widthPixels);
        result.putInt("height", displayMetrics.heightPixels);
        result.putDouble("scale", displayMetrics.density);
        result.putDouble("fontScale", fontScale);
        result.putDouble("densityDpi", displayMetrics.densityDpi);
        return result;
    }
}

