/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.fabric.LongStreamingStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DevToolsReactPerfLogger
implements ReactMarker.FabricMarkerListener {
    private final Map<Integer, FabricCommitPoint> mFabricCommitMarkers = new HashMap<Integer, FabricCommitPoint>();
    private final List<DevToolsReactPerfLoggerListener> mDevToolsReactPerfLoggerListeners = new ArrayList<DevToolsReactPerfLoggerListener>();
    public static final LongStreamingStats mStreamingCommitStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingLayoutStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingDiffStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingTransactionEndStats = new LongStreamingStats();
    public static final LongStreamingStats mStreamingBatchExecutionStats = new LongStreamingStats();

    public void addDevToolsReactPerfLoggerListener(DevToolsReactPerfLoggerListener listener) {
        this.mDevToolsReactPerfLoggerListeners.add(listener);
    }

    public void removeDevToolsReactPerfLoggerListener(DevToolsReactPerfLoggerListener listener) {
        this.mDevToolsReactPerfLoggerListeners.remove(listener);
    }

    @Override
    public void logFabricMarker(ReactMarkerConstants name, @Nullable String tag, int instanceKey, long timestamp) {
        if (DevToolsReactPerfLogger.isFabricCommitMarker(name)) {
            FabricCommitPoint commitPoint = this.mFabricCommitMarkers.get(instanceKey);
            if (commitPoint == null) {
                commitPoint = new FabricCommitPoint(instanceKey);
                this.mFabricCommitMarkers.put(instanceKey, commitPoint);
            }
            commitPoint.addPoint(name, timestamp);
            if (name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END) {
                this.onFabricCommitEnd(commitPoint);
                this.mFabricCommitMarkers.remove(instanceKey);
            }
        }
    }

    private void onFabricCommitEnd(FabricCommitPoint commitPoint) {
        for (DevToolsReactPerfLoggerListener listener : this.mDevToolsReactPerfLoggerListeners) {
            listener.onFabricCommitEnd(commitPoint);
        }
    }

    private static boolean isFabricCommitMarker(ReactMarkerConstants name) {
        return name == ReactMarkerConstants.FABRIC_COMMIT_START || name == ReactMarkerConstants.FABRIC_COMMIT_END || name == ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START || name == ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END || name == ReactMarkerConstants.FABRIC_DIFF_START || name == ReactMarkerConstants.FABRIC_DIFF_END || name == ReactMarkerConstants.FABRIC_LAYOUT_START || name == ReactMarkerConstants.FABRIC_LAYOUT_END || name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START || name == ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END || name == ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START || name == ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END;
    }

    public static class FabricCommitPoint {
        private final long mCommitNumber;
        private final Map<ReactMarkerConstants, Long> mPoints = new HashMap<ReactMarkerConstants, Long>();

        private FabricCommitPoint(int commitNumber) {
            this.mCommitNumber = commitNumber;
        }

        private void addPoint(ReactMarkerConstants key, long time) {
            this.mPoints.put(key, time);
        }

        private long getValue(ReactMarkerConstants marker) {
            Long value = this.mPoints.get((Object)marker);
            return value != null ? value : -1L;
        }

        public long getCommitNumber() {
            return this.mCommitNumber;
        }

        public long getCommitStart() {
            return this.getValue(ReactMarkerConstants.FABRIC_COMMIT_START);
        }

        public long getCommitEnd() {
            return this.getValue(ReactMarkerConstants.FABRIC_COMMIT_END);
        }

        public long getFinishTransactionStart() {
            return this.getValue(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START);
        }

        public long getFinishTransactionEnd() {
            return this.getValue(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END);
        }

        public long getDiffStart() {
            return this.getValue(ReactMarkerConstants.FABRIC_DIFF_START);
        }

        public long getDiffEnd() {
            return this.getValue(ReactMarkerConstants.FABRIC_DIFF_END);
        }

        public long getLayoutStart() {
            return this.getValue(ReactMarkerConstants.FABRIC_LAYOUT_START);
        }

        public long getLayoutEnd() {
            return this.getValue(ReactMarkerConstants.FABRIC_LAYOUT_END);
        }

        public long getBatchExecutionStart() {
            return this.getValue(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START);
        }

        public long getBatchExecutionEnd() {
            return this.getValue(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END);
        }

        public long getUpdateUIMainThreadStart() {
            return this.getValue(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START);
        }

        public long getUpdateUIMainThreadEnd() {
            return this.getValue(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END);
        }

        public long getCommitDuration() {
            return this.getCommitEnd() - this.getCommitStart();
        }

        public long getLayoutDuration() {
            return this.getLayoutEnd() - this.getLayoutStart();
        }

        public long getDiffDuration() {
            return this.getDiffEnd() - this.getDiffStart();
        }

        public long getTransactionEndDuration() {
            return this.getFinishTransactionEnd() - this.getFinishTransactionStart();
        }

        public long getBatchExecutionDuration() {
            return this.getBatchExecutionEnd() - this.getBatchExecutionStart();
        }
    }

    public static interface DevToolsReactPerfLoggerListener {
        public void onFabricCommitEnd(FabricCommitPoint var1);
    }
}

